/*
 * Decompiled with CFR 0.152.
 */
package io.openvalidation.core;

import io.openvalidation.common.ast.ASTModel;
import io.openvalidation.common.interfaces.IOpenValidationGenerator;
import io.openvalidation.common.interfaces.IOpenValidationParser;
import io.openvalidation.common.interfaces.IOpenValidationPreprocessor;
import io.openvalidation.common.model.CodeGenerationResult;
import io.openvalidation.common.model.Language;
import io.openvalidation.common.model.PreProcessorContext;
import io.openvalidation.common.validation.Validator;
import io.openvalidation.core.OpenValidationOptions;
import io.openvalidation.core.validation.ASTModelValidator;
import io.openvalidation.core.validation.ValidationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Engine {
    private IOpenValidationParser _parser;
    private IOpenValidationGenerator _generator;
    private IOpenValidationPreprocessor _preProcessor;
    private OpenValidationOptions _options;
    private PreProcessorContext _preprocessorCtx = null;

    public Engine(IOpenValidationPreprocessor preprocessor, IOpenValidationParser parser, IOpenValidationGenerator generator, OpenValidationOptions options) {
        this._parser = parser;
        this._generator = generator;
        this._preProcessor = preprocessor;
        this._options = options;
        this._preprocessorCtx = new PreProcessorContext();
    }

    public CodeGenerationResult generateFramework(ASTModel ast, Language language) throws Exception {
        String framework = this._generator.generateFramework(ast, language);
        return CodeGenerationResult.createFrameworkResult((ASTModel)ast, (String)framework);
    }

    public CodeGenerationResult generateValidatorFactory(Map<String, Object> params, Language language) throws Exception {
        String code = this._generator.generateValidatorFactory(params, language);
        return CodeGenerationResult.createValidatorFactoryResult((String)code);
    }

    public CodeGenerationResult generateCode(String plainRule, Locale locale, Language language, boolean isSingleFile) throws Exception {
        Validator.shouldNotBeEmpty((String)plainRule, (String)"the Rule Set");
        ArrayList<String> parsedRule = new ArrayList<String>();
        ASTModel ast = this.parse(plainRule, locale, parsedRule);
        if (ast != null && this._options.getParams() != null) {
            ast.addParams(this._options.getParams());
        }
        this.validate(new ValidationContext(this._options, ast, plainRule, (String)parsedRule.get(0)));
        String code = this._generator.generate(ast, language);
        CodeGenerationResult result = isSingleFile ? CodeGenerationResult.createCombined((ASTModel)ast, (String)code) : CodeGenerationResult.createImplementation((ASTModel)ast, (String)code);
        result.setName(this._options.getOutputCodeFileName());
        return result;
    }

    public ASTModel parse(String plainRule, Locale locale) throws Exception {
        return this.parse(plainRule, locale, null);
    }

    public ASTModel parse(String plainRule, Locale locale, List<String> preprocessedRules) throws Exception {
        String ruleContent = this.preprocess(plainRule, locale);
        ASTModel model = this._parser.parse(ruleContent, this._options.getSchema());
        if (preprocessedRules != null) {
            preprocessedRules.add(ruleContent);
        }
        if (model != null) {
            model.addParam("single_file", (Object)this._options.isSingleFile());
        }
        return model;
    }

    public void validate(ValidationContext context) throws Exception {
        Validator.shouldNotBeEmpty((Object)context, (String)"ValidationContext");
        Validator.shouldNotBeEmpty((Object)context.getAst(), (String)"ASTModel");
        ASTModelValidator validator = new ASTModelValidator(context);
        validator.validate();
    }

    public String preprocess(String plainRule, Locale locale) throws Exception {
        Validator.contentsShouldNotBeEmpty((String[])this._options.getWorkingDirectories(), (String)"WorkingDirectories");
        this._preprocessorCtx.setWorkingDirectory(this._options.getWorkingDirectories());
        this._preprocessorCtx.setLocale(locale);
        this._preprocessorCtx.setSchema(this._options.getSchema());
        return this._preProcessor.process(plainRule, this._preprocessorCtx);
    }

    public void setOptions(OpenValidationOptions options) {
        this._options = options;
    }
}

