/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.tomcat.v7_0;

import com.google.auto.service.AutoService;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatServerHandlerInstrumentation;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationModuleMuzzle;
import io.opentelemetry.javaagent.tooling.muzzle.VirtualFieldMappingsBuilder;
import io.opentelemetry.javaagent.tooling.muzzle.references.ClassRef;
import io.opentelemetry.javaagent.tooling.muzzle.references.Flag;
import io.opentelemetry.javaagent.tooling.muzzle.references.Source;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.objectweb.asm.Type;

@AutoService(value={InstrumentationModule.class})
public class Tomcat7InstrumentationModule
extends InstrumentationModule
implements InstrumentationModuleMuzzle {
    public Tomcat7InstrumentationModule() {
        super("tomcat", new String[]{"tomcat-7.0"});
    }

    public ElementMatcher.Junction<ClassLoader> classLoaderMatcher() {
        return ElementMatchers.not((ElementMatcher)AgentElementMatchers.hasClassesNamed((String[])new String[]{"jakarta.servlet.ReadListener"}));
    }

    public List<TypeInstrumentation> typeInstrumentations() {
        String packageName = Tomcat7InstrumentationModule.class.getPackage().getName();
        return Collections.singletonList(new TomcatServerHandlerInstrumentation(packageName + ".Tomcat7ServerHandlerAdvice", packageName + ".Tomcat7AttachResponseAdvice"));
    }

    public Map getMuzzleReferences() {
        HashMap<String, ClassRef> hashMap = new HashMap<String, ClassRef>(23, 0.75f);
        hashMap.put("org.apache.coyote.Request", ClassRef.builder((String)"org.apache.coyote.Request").addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7AttachResponseAdvice", 24).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 37).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 52).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 58).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 63).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ServletEntityProvider", 22).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ServletEntityProvider", 14).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 22).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 28).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 35).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 41).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 46).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 18).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 21).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 31).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 41).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 46).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 52).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 53).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 59).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 60).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 66).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 67).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 73).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 74).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 16).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 17).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 22).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 12).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ServerHandlerAdvice", 29).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ServerHandlerAdvice", 33).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ServerHandlerAdvice", 49).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 37)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "setAttribute", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"Ljava/lang/Object;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ServletEntityProvider", 22)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getNote", Type.getType((String)"Ljava/lang/Object;"), new Type[]{Type.getType((String)"I")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 22)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "method", Type.getType((String)"Lorg/apache/tomcat/util/buf/MessageBytes;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 28)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "scheme", Type.getType((String)"Lorg/apache/tomcat/util/buf/MessageBytes;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 35)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "requestURI", Type.getType((String)"Lorg/apache/tomcat/util/buf/MessageBytes;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 41)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "queryString", Type.getType((String)"Lorg/apache/tomcat/util/buf/MessageBytes;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 46), new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 17)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getMimeHeaders", Type.getType((String)"Lorg/apache/tomcat/util/http/MimeHeaders;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 21), new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 31)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "protocol", Type.getType((String)"Lorg/apache/tomcat/util/buf/MessageBytes;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 41)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "serverName", Type.getType((String)"Lorg/apache/tomcat/util/buf/MessageBytes;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 46)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getServerPort", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 52), new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 59), new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 66), new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 73)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "action", Type.getType((String)"V"), new Type[]{Type.getType((String)"Lorg/apache/coyote/ActionCode;"), Type.getType((String)"Ljava/lang/Object;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 53)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "remoteAddr", Type.getType((String)"Lorg/apache/tomcat/util/buf/MessageBytes;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 60)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getRemotePort", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 67)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "localAddr", Type.getType((String)"Lorg/apache/tomcat/util/buf/MessageBytes;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 74)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getLocalPort", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 22)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeader", Type.getType((String)"Ljava/lang/String;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).build());
        hashMap.put("org.apache.coyote.Response", ClassRef.builder((String)"org.apache.coyote.Response").addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7AttachResponseAdvice", 24).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 64).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ServletEntityProvider", 33).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ServletEntityProvider", 14).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 53).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 58).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 18).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 16).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ServerHandlerAdvice", 49).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ResponseMutator", 18).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ResponseMutator", 11).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ServletEntityProvider", 33)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getNote", Type.getType((String)"Ljava/lang/Object;"), new Type[]{Type.getType((String)"I")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 53)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getStatus", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 58)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getMimeHeaders", Type.getType((String)"Lorg/apache/tomcat/util/http/MimeHeaders;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ResponseMutator", 18)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "addHeader", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"Ljava/lang/String;")}).build());
        hashMap.put("org.apache.tomcat.util.buf.MessageBytes", ClassRef.builder((String)"org.apache.tomcat.util.buf.MessageBytes").addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 76).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 77).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 79).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 22).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 28).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 29).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 35).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 41).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 21).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 31).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 41).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 53).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 67).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 76)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getType", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 77)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getByteChunk", Type.getType((String)"Lorg/apache/tomcat/util/buf/ByteChunk;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 79)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "toString", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 29)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "isNull", Type.getType((String)"Z"), new Type[0]).build());
        hashMap.put("org.apache.tomcat.util.buf.ByteChunk", ClassRef.builder((String)"org.apache.tomcat.util.buf.ByteChunk").addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 77).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 77)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "toString", Type.getType((String)"Ljava/lang/String;"), new Type[0]).build());
        hashMap.put("javax.servlet.http.HttpServletRequest", ClassRef.builder((String)"javax.servlet.http.HttpServletRequest").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 28).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 33).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 38).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 48).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 20).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ServletEntityProvider", 24).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ServletEntityProvider", 25).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ServletEntityProvider", 14).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 20).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 25).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 30).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 35).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 40).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 45).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 50).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 55).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 60).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 65).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 70).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 75).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 81).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 88).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 95).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 101).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 106).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 111).addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 17).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 28)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getRemotePort", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 33)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getLocalAddr", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 38)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getLocalPort", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 48)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getAsyncContext", Type.getType((String)"Ljavax/servlet/AsyncContext;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 20)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getContextPath", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 25)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getScheme", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 30)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getRequestURI", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 35)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getQueryString", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 40)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getAttribute", Type.getType((String)"Ljava/lang/Object;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 45)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "setAttribute", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"Ljava/lang/Object;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 50)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getProtocol", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 55)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getMethod", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 60)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getServerName", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 65)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getServerPort", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 70)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getRemoteAddr", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 75)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeader", Type.getType((String)"Ljava/lang/String;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 81)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeaders", Type.getType((String)"Ljava/util/Enumeration;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 88)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeaderNames", Type.getType((String)"Ljava/util/Enumeration;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 95)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getParameterValues", Type.getType((String)"[Ljava/lang/String;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 101)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getServletPath", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 106)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getPathInfo", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 111)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getUserPrincipal", Type.getType((String)"Ljava/security/Principal;"), new Type[0]).build());
        hashMap.put("javax.servlet.http.HttpServletResponse", ClassRef.builder((String)"javax.servlet.http.HttpServletResponse").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 46).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 48).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 55).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 60).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 72).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 77).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 20).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ServletEntityProvider", 35).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ServletEntityProvider", 36).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ServletEntityProvider", 14).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 89).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 99).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 55)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getStatus", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 60)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeaders", Type.getType((String)"Ljava/util/Collection;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 72)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "isCommitted", Type.getType((String)"Z"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 77)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "addHeader", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"Ljava/lang/String;")}).build());
        hashMap.put("javax.servlet.AsyncContext", ClassRef.builder((String)"javax.servlet.AsyncContext").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 48).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 49).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 94).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 104).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 49)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "addListener", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljavax/servlet/AsyncListener;"), Type.getType((String)"Ljavax/servlet/ServletRequest;"), Type.getType((String)"Ljavax/servlet/ServletResponse;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 94)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getTimeout", Type.getType((String)"J"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 104)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "addListener", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljavax/servlet/AsyncListener;")}).build());
        hashMap.put("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", ClassRef.builder((String)"io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 48).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 0).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 84).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 89).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 94).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 99).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 80).addFlag((Flag)Flag.MinimumVisibilityFlag.PACKAGE_OR_HIGHER).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.ManifestationFlag.NON_FINAL).addFlag((Flag)Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER).setSuperClassName("java.lang.Object").addInterfaceName("javax.servlet.AsyncListener").addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 84), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 89), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 94), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 99)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.NON_STATIC}, "listener", Type.getType((String)"Lio/opentelemetry/javaagent/instrumentation/servlet/ServletAsyncListener;"), true).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "onComplete", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljavax/servlet/AsyncEvent;")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "onTimeout", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljavax/servlet/AsyncEvent;")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "onError", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljavax/servlet/AsyncEvent;")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "onStartAsync", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljavax/servlet/AsyncEvent;")}).build());
        hashMap.put("javax.servlet.AsyncListener", ClassRef.builder((String)"javax.servlet.AsyncListener").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 49).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 0).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 104).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("javax.servlet.ServletRequest", ClassRef.builder((String)"javax.servlet.ServletRequest").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 49).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("javax.servlet.ServletResponse", ClassRef.builder((String)"javax.servlet.ServletResponse").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor", 49).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 89).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 99).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("javax.servlet.Servlet", ClassRef.builder((String)"javax.servlet.Servlet").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Singletons", 68).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Singletons", 70).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Singletons", 36).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("javax.servlet.Filter", ClassRef.builder((String)"javax.servlet.Filter").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Singletons", 72).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Singletons", 38).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("javax.servlet.ServletException", ClassRef.builder((String)"javax.servlet.ServletException").addSource("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor", 116).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("javax.servlet.AsyncEvent", ClassRef.builder((String)"javax.servlet.AsyncEvent").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 89).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 94).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 99).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 104).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 89), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 99)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getSuppliedResponse", Type.getType((String)"Ljavax/servlet/ServletResponse;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 94), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 104)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getAsyncContext", Type.getType((String)"Ljavax/servlet/AsyncContext;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener", 99)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getThrowable", Type.getType((String)"Ljava/lang/Throwable;"), new Type[0]).build());
        hashMap.put("org.apache.tomcat.util.http.MimeHeaders", ClassRef.builder((String)"org.apache.tomcat.util.http.MimeHeaders").addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 46).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 58).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 17).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 46), new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 58)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "values", Type.getType((String)"Ljava/util/Enumeration;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 17)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "names", Type.getType((String)"Ljava/util/Enumeration;"), new Type[0]).build());
        hashMap.put("org.apache.coyote.ActionCode", ClassRef.builder((String)"org.apache.coyote.ActionCode").addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 52).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 59).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 66).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 73).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 52)}, new Flag[]{Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER, Flag.OwnershipFlag.STATIC}, "REQ_HOST_ADDR_ATTRIBUTE", Type.getType((String)"Lorg/apache/coyote/ActionCode;"), false).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 59)}, new Flag[]{Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER, Flag.OwnershipFlag.STATIC}, "REQ_REMOTEPORT_ATTRIBUTE", Type.getType((String)"Lorg/apache/coyote/ActionCode;"), false).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 66)}, new Flag[]{Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER, Flag.OwnershipFlag.STATIC}, "REQ_LOCAL_ADDR_ATTRIBUTE", Type.getType((String)"Lorg/apache/coyote/ActionCode;"), false).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter", 73)}, new Flag[]{Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER, Flag.OwnershipFlag.STATIC}, "REQ_LOCALPORT_ATTRIBUTE", Type.getType((String)"Lorg/apache/coyote/ActionCode;"), false).build());
        return hashMap;
    }

    public List getMuzzleHelperClassNames() {
        ArrayList<String> arrayList = new ArrayList<String>(32);
        arrayList.add("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7Singletons");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatServletEntityProvider");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatInstrumenterFactory");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Singletons");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletAccessor");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.BaseServletHelper");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestContext");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletAsyncListener");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.AsyncRunnableWrapper");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletResponseContext");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$Listener");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor$1");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletErrorCauseExtractor");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatNetAttributesGetter");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.snippet.OutputStreamSnippetInjectionHelper");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletInstrumenterBuilder");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.common.response.ResponseInstrumenterFactory");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletSpanNameProvider");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestParametersExtractor");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletNetAttributesGetter");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletAdditionalAttributesExtractor");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestGetter");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletHttpAttributesGetter");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ResponseMutator");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.tomcat.v7_0.Tomcat7ServletEntityProvider");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.javax.JavaxServletAccessor");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletHelper");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.AsyncRequestCompletionListener");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.v3_0.Servlet3Accessor");
        return arrayList;
    }

    public void registerMuzzleVirtualFields(VirtualFieldMappingsBuilder virtualFieldMappingsBuilder) {
        virtualFieldMappingsBuilder.register("javax.servlet.Servlet", "io.opentelemetry.javaagent.bootstrap.servlet.MappingResolver$Factory").register("javax.servlet.Filter", "io.opentelemetry.javaagent.bootstrap.servlet.MappingResolver$Factory");
    }
}

