/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.tomcat.v10_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.bootstrap.http.HttpServerResponseCustomizerHolder;
import io.opentelemetry.javaagent.bootstrap.http.HttpServerResponseMutator;
import io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ResponseMutator;
import io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10Singletons;
import net.bytebuddy.asm.Advice;
import org.apache.coyote.Request;
import org.apache.coyote.Response;

public class Tomcat10ServerHandlerAdvice {
    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void onEnter(@Advice.Argument(value=0) Request request, @Advice.Argument(value=1) Response response, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
        Context parentContext = Java8BytecodeBridge.currentContext();
        if (!Tomcat10Singletons.helper().shouldStart(parentContext, request)) {
            return;
        }
        context = Tomcat10Singletons.helper().start(parentContext, request);
        scope = context.makeCurrent();
        HttpServerResponseCustomizerHolder.getCustomizer().customize(context, (Object)response, (HttpServerResponseMutator)Tomcat10ResponseMutator.INSTANCE);
    }

    @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
    public static void stopSpan(@Advice.Argument(value=0) Request request, @Advice.Argument(value=1) Response response, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
        Tomcat10Singletons.helper().end(request, response, throwable, context, scope);
    }
}

