/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.spring.kafka;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingSpanNameExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaInstrumenterFactory;
import io.opentelemetry.javaagent.instrumentation.spring.kafka.KafkaBatchProcessAttributesGetter;
import io.opentelemetry.javaagent.instrumentation.spring.kafka.KafkaBatchProcessSpanLinksExtractor;
import io.opentelemetry.javaagent.instrumentation.spring.kafka.SpringKafkaErrorCauseExtractor;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;

public final class SpringKafkaSingletons {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-kafka-2.7";
    private static final Instrumenter<ConsumerRecords<?, ?>, Void> BATCH_PROCESS_INSTRUMENTER = SpringKafkaSingletons.buildBatchProcessInstrumenter();
    private static final Instrumenter<ConsumerRecord<?, ?>, Void> PROCESS_INSTRUMENTER = KafkaInstrumenterFactory.createConsumerProcessInstrumenter((String)"io.opentelemetry.spring-kafka-2.7", (ErrorCauseExtractor)SpringKafkaErrorCauseExtractor.INSTANCE);

    private static Instrumenter<ConsumerRecords<?, ?>, Void> buildBatchProcessInstrumenter() {
        KafkaBatchProcessAttributesGetter getter = KafkaBatchProcessAttributesGetter.INSTANCE;
        MessageOperation operation = MessageOperation.PROCESS;
        return Instrumenter.builder((OpenTelemetry)GlobalOpenTelemetry.get(), (String)INSTRUMENTATION_NAME, (SpanNameExtractor)MessagingSpanNameExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addAttributesExtractor((AttributesExtractor)MessagingAttributesExtractor.create((MessagingAttributesGetter)getter, (MessageOperation)operation)).addSpanLinksExtractor((SpanLinksExtractor)new KafkaBatchProcessSpanLinksExtractor(GlobalOpenTelemetry.getPropagators())).setErrorCauseExtractor((ErrorCauseExtractor)SpringKafkaErrorCauseExtractor.INSTANCE).newInstrumenter(SpanKindExtractor.alwaysConsumer());
    }

    public static Instrumenter<ConsumerRecords<?, ?>, Void> batchProcessInstrumenter() {
        return BATCH_PROCESS_INSTRUMENTER;
    }

    public static Instrumenter<ConsumerRecord<?, ?>, Void> processInstrumenter() {
        return PROCESS_INSTRUMENTER;
    }

    private SpringKafkaSingletons() {
    }
}

