/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.spring.kafka;

import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;

enum KafkaBatchProcessAttributesGetter implements MessagingAttributesGetter<ConsumerRecords<?, ?>, Void>
{
    INSTANCE;


    public String system(ConsumerRecords<?, ?> records) {
        return "kafka";
    }

    public String destinationKind(ConsumerRecords<?, ?> records) {
        return "topic";
    }

    @Nullable
    public String destination(ConsumerRecords<?, ?> records) {
        Set topics = records.partitions().stream().map(TopicPartition::topic).collect(Collectors.toSet());
        return topics.size() == 1 ? (String)topics.iterator().next() : null;
    }

    public boolean temporaryDestination(ConsumerRecords<?, ?> records) {
        return false;
    }

    @Nullable
    public String protocol(ConsumerRecords<?, ?> records) {
        return null;
    }

    @Nullable
    public String protocolVersion(ConsumerRecords<?, ?> records) {
        return null;
    }

    @Nullable
    public String url(ConsumerRecords<?, ?> records) {
        return null;
    }

    @Nullable
    public String conversationId(ConsumerRecords<?, ?> records) {
        return null;
    }

    @Nullable
    public Long messagePayloadSize(ConsumerRecords<?, ?> records) {
        return null;
    }

    @Nullable
    public Long messagePayloadCompressedSize(ConsumerRecords<?, ?> records) {
        return null;
    }

    @Nullable
    public String messageId(ConsumerRecords<?, ?> records, @Nullable Void unused) {
        return null;
    }
}

