/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.spring.kafka;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.field.VirtualField;
import io.opentelemetry.javaagent.instrumentation.spring.kafka.SpringKafkaSingletons;
import io.opentelemetry.javaagent.instrumentation.spring.kafka.State;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.RecordInterceptor;

public final class InstrumentedRecordInterceptor<K, V>
implements RecordInterceptor<K, V> {
    private final VirtualField<ConsumerRecord<K, V>, Context> receiveContextField;
    private final VirtualField<ConsumerRecord<K, V>, State<ConsumerRecord<K, V>>> stateField;
    @Nullable
    private final RecordInterceptor<K, V> decorated;

    public InstrumentedRecordInterceptor(VirtualField<ConsumerRecord<K, V>, Context> receiveContextField, VirtualField<ConsumerRecord<K, V>, State<ConsumerRecord<K, V>>> stateField, @Nullable RecordInterceptor<K, V> decorated) {
        this.receiveContextField = receiveContextField;
        this.stateField = stateField;
        this.decorated = decorated;
    }

    public ConsumerRecord<K, V> intercept(ConsumerRecord<K, V> record) {
        this.start(record);
        return this.decorated == null ? record : this.decorated.intercept(record);
    }

    public ConsumerRecord<K, V> intercept(ConsumerRecord<K, V> record, Consumer<K, V> consumer) {
        this.start(record);
        return this.decorated == null ? record : this.decorated.intercept(record, consumer);
    }

    private void start(ConsumerRecord<K, V> record) {
        Context parentContext = this.getParentContext(record);
        if (SpringKafkaSingletons.processInstrumenter().shouldStart(parentContext, record)) {
            Context context = SpringKafkaSingletons.processInstrumenter().start(parentContext, record);
            Scope scope = context.makeCurrent();
            this.stateField.set(record, State.create(record, context, scope));
        }
    }

    private Context getParentContext(ConsumerRecord<K, V> records) {
        Context receiveContext = (Context)this.receiveContextField.get(records);
        return receiveContext != null ? receiveContext : Context.current();
    }

    public void success(ConsumerRecord<K, V> record, Consumer<K, V> consumer) {
        this.end(record, null);
        if (this.decorated != null) {
            this.decorated.success(record, consumer);
        }
    }

    public void failure(ConsumerRecord<K, V> record, Exception exception, Consumer<K, V> consumer) {
        this.end(record, exception);
        if (this.decorated != null) {
            this.decorated.failure(record, exception, consumer);
        }
    }

    private void end(ConsumerRecord<K, V> record, @Nullable Throwable error) {
        State state = (State)this.stateField.get(record);
        this.stateField.set(record, null);
        if (state != null) {
            state.scope().close();
            SpringKafkaSingletons.processInstrumenter().end(state.context(), (Object)((ConsumerRecord)state.request()), null, error);
        }
    }
}

