/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.spring.kafka;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.field.VirtualField;
import io.opentelemetry.javaagent.instrumentation.spring.kafka.SpringKafkaSingletons;
import io.opentelemetry.javaagent.instrumentation.spring.kafka.State;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.kafka.listener.BatchInterceptor;

public final class InstrumentedBatchInterceptor<K, V>
implements BatchInterceptor<K, V> {
    private final VirtualField<ConsumerRecords<K, V>, Context> receiveContextField;
    private final VirtualField<ConsumerRecords<K, V>, State<ConsumerRecords<K, V>>> stateField;
    @Nullable
    private final BatchInterceptor<K, V> decorated;

    public InstrumentedBatchInterceptor(VirtualField<ConsumerRecords<K, V>, Context> receiveContextField, VirtualField<ConsumerRecords<K, V>, State<ConsumerRecords<K, V>>> stateField, @Nullable BatchInterceptor<K, V> decorated) {
        this.receiveContextField = receiveContextField;
        this.stateField = stateField;
        this.decorated = decorated;
    }

    public ConsumerRecords<K, V> intercept(ConsumerRecords<K, V> records, Consumer<K, V> consumer) {
        Context parentContext = this.getParentContext(records);
        if (SpringKafkaSingletons.batchProcessInstrumenter().shouldStart(parentContext, records)) {
            Context context = SpringKafkaSingletons.batchProcessInstrumenter().start(parentContext, records);
            Scope scope = context.makeCurrent();
            this.stateField.set((Object)records, State.create(records, context, scope));
        }
        return this.decorated == null ? records : this.decorated.intercept(records, consumer);
    }

    private Context getParentContext(ConsumerRecords<K, V> records) {
        Context receiveContext = (Context)this.receiveContextField.get(records);
        return receiveContext != null ? receiveContext : Context.current();
    }

    public void success(ConsumerRecords<K, V> records, Consumer<K, V> consumer) {
        this.end(records, null);
        if (this.decorated != null) {
            this.decorated.success(records, consumer);
        }
    }

    public void failure(ConsumerRecords<K, V> records, Exception exception, Consumer<K, V> consumer) {
        this.end(records, exception);
        if (this.decorated != null) {
            this.decorated.failure(records, exception, consumer);
        }
    }

    private void end(ConsumerRecords<K, V> records, @Nullable Throwable error) {
        State state = (State)this.stateField.get(records);
        this.stateField.set(records, null);
        if (state != null) {
            state.scope().close();
            SpringKafkaSingletons.batchProcessInstrumenter().end(state.context(), (Object)((ConsumerRecords)state.request()), null, error);
        }
    }
}

