/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.spring.kafka;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.field.VirtualField;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.spring.kafka.InstrumentedBatchInterceptor;
import io.opentelemetry.javaagent.instrumentation.spring.kafka.InstrumentedRecordInterceptor;
import io.opentelemetry.javaagent.instrumentation.spring.kafka.State;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.kafka.listener.BatchInterceptor;
import org.springframework.kafka.listener.RecordInterceptor;

public class AbstractMessageListenerContainerInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"org.springframework.kafka.listener.AbstractMessageListenerContainer");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"getBatchInterceptor").and((ElementMatcher)ElementMatchers.isProtected()).and((ElementMatcher)ElementMatchers.takesArguments((int)0)).and((ElementMatcher)ElementMatchers.returns((ElementMatcher)ElementMatchers.named((String)"org.springframework.kafka.listener.BatchInterceptor"))), this.getClass().getName() + "$GetBatchInterceptorAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"getRecordInterceptor").and((ElementMatcher)ElementMatchers.isProtected()).and((ElementMatcher)ElementMatchers.takesArguments((int)0)).and((ElementMatcher)ElementMatchers.returns((ElementMatcher)ElementMatchers.named((String)"org.springframework.kafka.listener.RecordInterceptor"))), this.getClass().getName() + "$GetRecordInterceptorAdvice");
    }

    public static class GetRecordInterceptorAdvice {
        @Advice.OnMethodExit(suppress=Throwable.class)
        public static <K, V> void onExit(@Advice.Return(readOnly=false) RecordInterceptor<K, V> interceptor) {
            if (!(interceptor instanceof InstrumentedRecordInterceptor)) {
                VirtualField receiveContextField = VirtualField.find(ConsumerRecord.class, Context.class);
                VirtualField stateField = VirtualField.find(ConsumerRecord.class, State.class);
                interceptor = new InstrumentedRecordInterceptor<K, V>(receiveContextField, stateField, interceptor);
            }
        }
    }

    public static class GetBatchInterceptorAdvice {
        @Advice.OnMethodExit(suppress=Throwable.class)
        public static <K, V> void onExit(@Advice.Return(readOnly=false) BatchInterceptor<K, V> interceptor) {
            if (!(interceptor instanceof InstrumentedBatchInterceptor)) {
                VirtualField receiveContextField = VirtualField.find(ConsumerRecords.class, Context.class);
                VirtualField stateField = VirtualField.find(ConsumerRecords.class, State.class);
                interceptor = new InstrumentedBatchInterceptor<K, V>(receiveContextField, stateField, interceptor);
            }
        }
    }
}

