/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet;

import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletAccessor;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestContext;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletResponseContext;
import java.util.List;
import javax.annotation.Nullable;

public class ServletHttpAttributesGetter<REQUEST, RESPONSE>
implements HttpServerAttributesGetter<ServletRequestContext<REQUEST>, ServletResponseContext<RESPONSE>> {
    protected final ServletAccessor<REQUEST, RESPONSE> accessor;

    public ServletHttpAttributesGetter(ServletAccessor<REQUEST, RESPONSE> accessor) {
        this.accessor = accessor;
    }

    @Nullable
    public String getHttpRequestMethod(ServletRequestContext<REQUEST> requestContext) {
        return this.accessor.getRequestMethod(requestContext.request());
    }

    @Nullable
    public String getUrlScheme(ServletRequestContext<REQUEST> requestContext) {
        return this.accessor.getRequestScheme(requestContext.request());
    }

    @Nullable
    public String getUrlPath(ServletRequestContext<REQUEST> requestContext) {
        return this.accessor.getRequestUri(requestContext.request());
    }

    @Nullable
    public String getUrlQuery(ServletRequestContext<REQUEST> requestContext) {
        return this.accessor.getRequestQueryString(requestContext.request());
    }

    public List<String> getHttpRequestHeader(ServletRequestContext<REQUEST> requestContext, String name) {
        return this.accessor.getRequestHeaderValues(requestContext.request(), name);
    }

    @Nullable
    public Integer getHttpResponseStatusCode(ServletRequestContext<REQUEST> requestContext, ServletResponseContext<RESPONSE> responseContext, @Nullable Throwable error) {
        RESPONSE response = responseContext.response();
        if (response == null) {
            return null;
        }
        if (!this.accessor.isResponseCommitted(response) && error != null) {
            return 500;
        }
        return this.accessor.getResponseStatus(response);
    }

    public List<String> getHttpResponseHeader(ServletRequestContext<REQUEST> requestContext, ServletResponseContext<RESPONSE> responseContext, String name) {
        return this.accessor.getResponseHeaderValues(responseContext.response(), name);
    }

    @Nullable
    public String getNetworkProtocolName(ServletRequestContext<REQUEST> requestContext, @Nullable ServletResponseContext<RESPONSE> responseContext) {
        String protocol = this.accessor.getRequestProtocol(requestContext.request());
        if (protocol != null && protocol.startsWith("HTTP/")) {
            return "http";
        }
        return null;
    }

    @Nullable
    public String getNetworkProtocolVersion(ServletRequestContext<REQUEST> requestContext, @Nullable ServletResponseContext<RESPONSE> responseContext) {
        String protocol = this.accessor.getRequestProtocol(requestContext.request());
        if (protocol != null && protocol.startsWith("HTTP/")) {
            return protocol.substring("HTTP/".length());
        }
        return null;
    }

    @Nullable
    public String getNetworkPeerAddress(ServletRequestContext<REQUEST> requestContext, @Nullable ServletResponseContext<RESPONSE> response) {
        return this.accessor.getRequestRemoteAddr(requestContext.request());
    }

    @Nullable
    public Integer getNetworkPeerPort(ServletRequestContext<REQUEST> requestContext, @Nullable ServletResponseContext<RESPONSE> response) {
        return this.accessor.getRequestRemotePort(requestContext.request());
    }

    @Nullable
    public String getNetworkLocalAddress(ServletRequestContext<REQUEST> requestContext, @Nullable ServletResponseContext<RESPONSE> response) {
        return this.accessor.getRequestLocalAddr(requestContext.request());
    }

    @Nullable
    public Integer getNetworkLocalPort(ServletRequestContext<REQUEST> requestContext, @Nullable ServletResponseContext<RESPONSE> response) {
        return this.accessor.getRequestLocalPort(requestContext.request());
    }
}

