/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.javaagent.instrumentation.servlet.AsyncRequestCompletionListener;
import io.opentelemetry.javaagent.instrumentation.servlet.AsyncRunnableWrapper;
import io.opentelemetry.javaagent.instrumentation.servlet.BaseServletHelper;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletAccessor;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestContext;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletResponseContext;

public class ServletHelper<REQUEST, RESPONSE>
extends BaseServletHelper<REQUEST, RESPONSE> {
    private static final String ASYNC_LISTENER_ATTRIBUTE = ServletHelper.class.getName() + ".AsyncListener";
    private static final String ASYNC_LISTENER_RESPONSE_ATTRIBUTE = ServletHelper.class.getName() + ".AsyncListenerResponse";
    public static final String ASYNC_EXCEPTION_ATTRIBUTE = ServletHelper.class.getName() + ".AsyncException";
    public static final String CONTEXT_ATTRIBUTE = ServletHelper.class.getName() + ".Context";

    public ServletHelper(Instrumenter<ServletRequestContext<REQUEST>, ServletResponseContext<RESPONSE>> instrumenter, ServletAccessor<REQUEST, RESPONSE> accessor) {
        super(instrumenter, accessor);
    }

    public void end(ServletRequestContext<REQUEST> requestContext, REQUEST request, RESPONSE response, Throwable throwable, boolean topLevel, Context context, Scope scope) {
        if (scope != null) {
            scope.close();
        }
        if (context == null && topLevel) {
            Context currentContext = Context.current();
            if (throwable != null) {
                this.recordException(currentContext, throwable);
                if (!this.mustEndOnHandlerMethodExit(request)) {
                    this.recordAsyncException(request, throwable);
                }
            }
            this.captureServletAttributes(currentContext, request);
        }
        if (scope == null || context == null) {
            return;
        }
        ServletResponseContext<RESPONSE> responseContext = new ServletResponseContext<RESPONSE>(response);
        if (throwable != null || this.mustEndOnHandlerMethodExit(request)) {
            this.instrumenter.end(context, requestContext, responseContext, throwable);
        }
    }

    public boolean mustEndOnHandlerMethodExit(REQUEST request) {
        return !this.isAsyncListenerAttached(request);
    }

    public void setAsyncListenerResponse(REQUEST request, RESPONSE response) {
        this.accessor.setRequestAttribute(request, ASYNC_LISTENER_RESPONSE_ATTRIBUTE, response);
    }

    public RESPONSE getAsyncListenerResponse(REQUEST request) {
        Object response = this.accessor.getRequestAttribute(request, ASYNC_LISTENER_RESPONSE_ATTRIBUTE);
        return (RESPONSE)response;
    }

    public void attachAsyncListener(REQUEST request) {
        ServletRequestContext<REQUEST> requestContext = new ServletRequestContext<REQUEST>(request, null);
        this.attachAsyncListener(requestContext);
    }

    private void attachAsyncListener(ServletRequestContext<REQUEST> requestContext) {
        REQUEST request = requestContext.request();
        Context context = this.getServerContext(request);
        if (context != null) {
            RESPONSE response = this.getAsyncListenerResponse(request);
            this.accessor.addRequestAsyncListener(request, new AsyncRequestCompletionListener(this, this.instrumenter, requestContext, context), response);
            this.accessor.setRequestAttribute(request, ASYNC_LISTENER_ATTRIBUTE, true);
        }
    }

    public boolean isAsyncListenerAttached(REQUEST request) {
        return this.accessor.getRequestAttribute(request, ASYNC_LISTENER_ATTRIBUTE) != null;
    }

    public Runnable wrapAsyncRunnable(REQUEST request, Runnable runnable) {
        return AsyncRunnableWrapper.wrap(this, request, runnable);
    }

    public void recordAsyncException(REQUEST request, Throwable throwable) {
        this.accessor.setRequestAttribute(request, ASYNC_EXCEPTION_ATTRIBUTE, throwable);
    }

    public Throwable getAsyncException(REQUEST request) {
        return (Throwable)this.accessor.getRequestAttribute(request, ASYNC_EXCEPTION_ATTRIBUTE);
    }
}

