/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet;

import io.opentelemetry.javaagent.instrumentation.servlet.ServletHelper;

public class AsyncRunnableWrapper<REQUEST>
implements Runnable {
    private final ServletHelper<REQUEST, ?> helper;
    private final REQUEST request;
    private final Runnable runnable;

    private AsyncRunnableWrapper(ServletHelper<REQUEST, ?> helper, REQUEST request, Runnable runnable) {
        this.helper = helper;
        this.request = request;
        this.runnable = runnable;
    }

    public static <REQUEST> Runnable wrap(ServletHelper<REQUEST, ?> helper, REQUEST request, Runnable runnable) {
        if (runnable == null || runnable instanceof AsyncRunnableWrapper) {
            return runnable;
        }
        return new AsyncRunnableWrapper<REQUEST>(helper, request, runnable);
    }

    @Override
    public void run() {
        try {
            this.runnable.run();
        }
        catch (Throwable throwable) {
            this.helper.recordAsyncException(this.request, throwable);
            throw throwable;
        }
    }
}

