/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletAsyncListener;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletHelper;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestContext;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletResponseContext;
import java.util.concurrent.atomic.AtomicBoolean;

public class AsyncRequestCompletionListener<REQUEST, RESPONSE>
implements ServletAsyncListener<RESPONSE> {
    private final ServletHelper<REQUEST, RESPONSE> servletHelper;
    private final Instrumenter<ServletRequestContext<REQUEST>, ServletResponseContext<RESPONSE>> instrumenter;
    private final ServletRequestContext<REQUEST> requestContext;
    private final Context context;
    private final AtomicBoolean responseHandled = new AtomicBoolean();

    public AsyncRequestCompletionListener(ServletHelper<REQUEST, RESPONSE> servletHelper, Instrumenter<ServletRequestContext<REQUEST>, ServletResponseContext<RESPONSE>> instrumenter, ServletRequestContext<REQUEST> requestContext, Context context) {
        this.servletHelper = servletHelper;
        this.instrumenter = instrumenter;
        this.requestContext = requestContext;
        this.context = context;
    }

    @Override
    public void onComplete(RESPONSE response) {
        if (this.responseHandled.compareAndSet(false, true)) {
            ServletResponseContext<RESPONSE> responseContext = new ServletResponseContext<RESPONSE>(response);
            Throwable throwable = this.servletHelper.getAsyncException(this.requestContext.request());
            this.instrumenter.end(this.context, this.requestContext, responseContext, throwable);
        }
    }

    @Override
    public void onTimeout(long timeout) {
        if (this.responseHandled.compareAndSet(false, true)) {
            RESPONSE response = this.servletHelper.getAsyncListenerResponse(this.requestContext.request());
            ServletResponseContext<RESPONSE> responseContext = new ServletResponseContext<RESPONSE>(response);
            responseContext.setTimeout(timeout);
            Throwable throwable = this.servletHelper.getAsyncException(this.requestContext.request());
            this.instrumenter.end(this.context, this.requestContext, responseContext, throwable);
        }
    }

    @Override
    public void onError(Throwable throwable, RESPONSE response) {
        if (this.responseHandled.compareAndSet(false, true)) {
            ServletResponseContext<RESPONSE> responseContext = new ServletResponseContext<RESPONSE>(response);
            this.instrumenter.end(this.context, this.requestContext, responseContext, throwable);
        }
    }
}

