/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.javaagent.runtimemetrics;

import com.google.auto.service.AutoService;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.runtimemetrics.BufferPools;
import io.opentelemetry.instrumentation.runtimemetrics.Classes;
import io.opentelemetry.instrumentation.runtimemetrics.Cpu;
import io.opentelemetry.instrumentation.runtimemetrics.GarbageCollector;
import io.opentelemetry.instrumentation.runtimemetrics.MemoryPools;
import io.opentelemetry.instrumentation.runtimemetrics.Threads;
import io.opentelemetry.javaagent.extension.AgentListener;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;

@AutoService(value={AgentListener.class})
public class RuntimeMetricsInstaller
implements AgentListener {
    public void afterAgent(AutoConfiguredOpenTelemetrySdk autoConfiguredSdk) {
        boolean defaultEnabled;
        ConfigProperties config = autoConfiguredSdk.getConfig();
        if (!config.getBoolean("otel.instrumentation.runtime-metrics.enabled", defaultEnabled = config.getBoolean("otel.instrumentation.common.default-enabled", true))) {
            return;
        }
        OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
        BufferPools.registerObservers((OpenTelemetry)openTelemetry);
        Classes.registerObservers((OpenTelemetry)openTelemetry);
        Cpu.registerObservers((OpenTelemetry)openTelemetry);
        MemoryPools.registerObservers((OpenTelemetry)openTelemetry);
        Threads.registerObservers((OpenTelemetry)openTelemetry);
        GarbageCollector.registerObservers((OpenTelemetry)openTelemetry);
    }
}

