/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.log4j.appender.v1_2;

import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.javaagent.bootstrap.CallDepth;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.log4j.appender.v1_2.LogEventMapper;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

class Log4jAppenderInstrumentation
implements TypeInstrumentation {
    Log4jAppenderInstrumentation() {
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"org.apache.log4j.Category");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.isProtected()).and((ElementMatcher)ElementMatchers.named((String)"forcedLog")).and((ElementMatcher)ElementMatchers.takesArguments((int)4)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, String.class)).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.log4j.Priority"))).and((ElementMatcher)ElementMatchers.takesArgument((int)2, Object.class)).and((ElementMatcher)ElementMatchers.takesArgument((int)3, Throwable.class)), Log4jAppenderInstrumentation.class.getName() + "$ForcedLogAdvice");
    }

    public static class ForcedLogAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.This Category logger, @Advice.Argument(value=1) Priority level, @Advice.Argument(value=2) Object message, @Advice.Argument(value=3) Throwable t, @Advice.Local(value="otelCallDepth") CallDepth callDepth) {
            callDepth = CallDepth.forClass(LoggerProvider.class);
            if (callDepth.getAndIncrement() == 0) {
                LogEventMapper.INSTANCE.capture(logger, level, message, t);
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Local(value="otelCallDepth") CallDepth callDepth) {
            callDepth.decrementAndGet();
        }
    }
}

