/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.ktor.v2_0;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationPluginKt;
import io.ktor.server.application.Plugin;
import io.ktor.util.pipeline.Pipeline;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.ktor.v2_0.server.KtorServerTracing;
import io.opentelemetry.javaagent.bootstrap.internal.CommonConfig;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ServerInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"io.ktor.server.engine.ApplicationEngineEnvironmentReloading");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isConstructor(), this.getClass().getName() + "$ConstructorAdvice");
    }

    public static class SetupFunction
    implements Function1<KtorServerTracing.Configuration, Unit> {
        public Unit invoke(KtorServerTracing.Configuration configuration) {
            OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
            configuration.setOpenTelemetry(openTelemetry);
            configuration.capturedRequestHeaders((Iterable)CommonConfig.get().getServerRequestHeaders());
            configuration.capturedResponseHeaders((Iterable)CommonConfig.get().getServerResponseHeaders());
            configuration.knownMethods((Iterable)CommonConfig.get().getKnownHttpRequestMethods());
            return Unit.INSTANCE;
        }
    }

    public static class ConstructorAdvice {
        @Advice.OnMethodExit
        public static void onExit(@Advice.FieldValue(value="_applicationInstance") Application application) {
            ApplicationPluginKt.install((Pipeline)application, (Plugin)KtorServerTracing.Feature, (Function1)new SetupFunction());
        }
    }
}

