/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.ktor.v2_0;

import io.ktor.client.HttpClientConfig;
import io.ktor.client.engine.HttpClientEngineConfig;
import io.ktor.client.plugins.HttpClientPlugin;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.ktor.v2_0.client.KtorClientTracing;
import io.opentelemetry.instrumentation.ktor.v2_0.client.KtorClientTracingBuilder;
import io.opentelemetry.javaagent.bootstrap.internal.CommonConfig;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class HttpClientInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"io.ktor.client.HttpClient");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isConstructor().and((ElementMatcher)ElementMatchers.takesArguments((int)2)).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"io.ktor.client.HttpClientConfig"))), this.getClass().getName() + "$ConstructorAdvice");
    }

    public static class SetupFunction
    implements Function1<KtorClientTracingBuilder, Unit> {
        public Unit invoke(KtorClientTracingBuilder builder) {
            OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
            builder.setOpenTelemetry(openTelemetry);
            builder.capturedRequestHeaders((Iterable)CommonConfig.get().getClientRequestHeaders());
            builder.capturedResponseHeaders((Iterable)CommonConfig.get().getClientResponseHeaders());
            builder.knownMethods((Iterable)CommonConfig.get().getKnownHttpRequestMethods());
            return Unit.INSTANCE;
        }
    }

    public static class ConstructorAdvice {
        @Advice.OnMethodEnter
        public static void onEnter(@Advice.Argument(value=1) HttpClientConfig<HttpClientEngineConfig> httpClientConfig) {
            httpClientConfig.install((HttpClientPlugin)KtorClientTracing.Companion, (Function1)new SetupFunction());
        }
    }
}

