/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.javaagent.jmx;

import com.google.auto.service.AutoService;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.jmx.engine.JmxMetricInsight;
import io.opentelemetry.instrumentation.jmx.engine.MetricConfiguration;
import io.opentelemetry.instrumentation.jmx.yaml.RuleParser;
import io.opentelemetry.javaagent.extension.AgentListener;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Level;

@AutoService(value={AgentListener.class})
public class JmxMetricInsightInstaller
implements AgentListener {
    public void afterAgent(AutoConfiguredOpenTelemetrySdk autoConfiguredSdk) {
        ConfigProperties config = autoConfiguredSdk.getConfig();
        if (config.getBoolean("otel.jmx.enabled", true)) {
            JmxMetricInsight service = JmxMetricInsight.createService((OpenTelemetry)GlobalOpenTelemetry.get(), (long)JmxMetricInsightInstaller.beanDiscoveryDelay(config));
            MetricConfiguration conf = JmxMetricInsightInstaller.buildMetricConfiguration(config);
            service.start(conf);
        }
    }

    private static long beanDiscoveryDelay(ConfigProperties configProperties) {
        Long discoveryDelay = configProperties.getLong("otel.jmx.discovery.delay");
        if (discoveryDelay != null) {
            return discoveryDelay;
        }
        long exportInterval = configProperties.getLong("otel.metric.export.interval", 60000L);
        return exportInterval;
    }

    private static String resourceFor(String platform) {
        return "/jmx/rules/" + platform + ".yaml";
    }

    private static void addRulesForPlatform(String platform, MetricConfiguration conf) {
        String yamlResource = JmxMetricInsightInstaller.resourceFor(platform);
        try (InputStream inputStream = JmxMetricInsightInstaller.class.getResourceAsStream(yamlResource);){
            if (inputStream != null) {
                JmxMetricInsight.getLogger().log(Level.FINE, "Opened input stream {0}", yamlResource);
                RuleParser parserInstance = RuleParser.get();
                parserInstance.addMetricDefsTo(conf, inputStream);
            } else {
                JmxMetricInsight.getLogger().log(Level.INFO, "No support found for {0}", platform);
            }
        }
        catch (Exception e) {
            JmxMetricInsight.getLogger().warning(e.getMessage());
        }
    }

    private static void buildFromDefaultRules(MetricConfiguration conf, ConfigProperties configProperties) {
        String[] platforms;
        String targetSystem = configProperties.getString("otel.jmx.target.system", "");
        for (String platform : platforms = targetSystem.isEmpty() ? new String[]{} : targetSystem.split(",")) {
            JmxMetricInsightInstaller.addRulesForPlatform(platform, conf);
        }
    }

    private static void buildFromUserRules(MetricConfiguration conf, ConfigProperties configProperties) {
        String jmxDir = configProperties.getString("otel.jmx.config");
        if (jmxDir != null) {
            JmxMetricInsight.getLogger().log(Level.FINE, "JMX config file name: {0}", jmxDir);
            RuleParser parserInstance = RuleParser.get();
            try (InputStream inputStream = Files.newInputStream(new File(jmxDir.trim()).toPath(), new OpenOption[0]);){
                parserInstance.addMetricDefsTo(conf, inputStream);
            }
            catch (Exception e) {
                JmxMetricInsight.getLogger().warning(e.getMessage());
            }
        }
    }

    private static MetricConfiguration buildMetricConfiguration(ConfigProperties configProperties) {
        MetricConfiguration metricConfiguration = new MetricConfiguration();
        JmxMetricInsightInstaller.buildFromDefaultRules(metricConfiguration, configProperties);
        JmxMetricInsightInstaller.buildFromUserRules(metricConfiguration, configProperties);
        return metricConfiguration;
    }
}

