/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.internal.lambda;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.javaagent.bootstrap.DefineClassHelper;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.internal.lambda.LambdaTransformer;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class InnerClassLambdaMetafactoryInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"java.lang.invoke.InnerClassLambdaMetafactory");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyTransformer((builder, typeDescription, classLoader, javaModule, protectionDomain) -> builder.visit(new AsmVisitorWrapper(){

            public int mergeWriter(int flags) {
                return flags | 1;
            }

            @CanIgnoreReturnValue
            public int mergeReader(int flags) {
                return flags;
            }

            public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
                return new MetaFactoryClassVisitor(classVisitor, instrumentedType.getInternalName());
            }
        }));
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"spinInnerClass"), InnerClassLambdaMetafactoryInstrumentation.class.getName() + (InnerClassLambdaMetafactoryInstrumentation.hasInterfaceClassField() ? "$LambdaJdk17Advice" : "$LambdaAdvice"));
    }

    private static boolean hasInterfaceClassField() {
        try {
            Class<?> clazz = Class.forName("java.lang.invoke.AbstractValidatingLambdaMetafactory");
            clazz.getDeclaredField("interfaceClass");
            return true;
        }
        catch (NoSuchFieldException exception) {
            return false;
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static class LambdaJdk17Advice {
        @Advice.OnMethodEnter
        public static DefineClassHelper.Handler.DefineClassContext onEnter(@Advice.FieldValue(value="interfaceClass") Class<?> lambdaInterface) {
            return DefineClassHelper.beforeDefineLambdaClass(lambdaInterface);
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class)
        public static void onExit(@Advice.Enter DefineClassHelper.Handler.DefineClassContext context) {
            DefineClassHelper.afterDefineClass((DefineClassHelper.Handler.DefineClassContext)context);
        }
    }

    public static class LambdaAdvice {
        @Advice.OnMethodEnter
        public static DefineClassHelper.Handler.DefineClassContext onEnter(@Advice.FieldValue(value="samBase") Class<?> lambdaInterface) {
            return DefineClassHelper.beforeDefineLambdaClass(lambdaInterface);
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class)
        public static void onExit(@Advice.Enter DefineClassHelper.Handler.DefineClassContext context) {
            DefineClassHelper.afterDefineClass((DefineClassHelper.Handler.DefineClassContext)context);
        }
    }

    private static class MetaFactoryClassVisitor
    extends ClassVisitor {
        private final String slashClassName;

        MetaFactoryClassVisitor(ClassVisitor cv, String slashClassName) {
            super(458752, cv);
            this.slashClassName = slashClassName;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (("spinInnerClass".equals(name) || "generateInnerClass".equals(name)) && "()Ljava/lang/Class;".equals(descriptor)) {
                mv = new MethodVisitor(this.api, mv){

                    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                        if (opcode == 182 && "toByteArray".equals(name) && "()[B".equals(descriptor)) {
                            this.mv.visitVarInsn(25, 0);
                            this.mv.visitFieldInsn(180, slashClassName, "lambdaClassName", "Ljava/lang/String;");
                            this.mv.visitVarInsn(25, 0);
                            this.mv.visitFieldInsn(180, slashClassName, "targetClass", "Ljava/lang/Class;");
                            this.mv.visitMethodInsn(184, Type.getInternalName(LambdaTransformer.class), "transform", "([BLjava/lang/String;Ljava/lang/Class;)[B", false);
                        }
                    }
                };
            }
            return mv;
        }
    }
}

