/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.internal.lambda;

import io.opentelemetry.javaagent.bootstrap.ClassFileTransformerHolder;
import io.opentelemetry.javaagent.bootstrap.InjectedClassHelper;
import io.opentelemetry.javaagent.instrumentation.internal.lambda.Java9LambdaTransformer;
import java.lang.instrument.ClassFileTransformer;

public final class LambdaTransformer {
    private static final boolean IS_JAVA_9 = LambdaTransformer.isJava9();

    private LambdaTransformer() {
    }

    private static boolean isJava9() {
        try {
            Class.forName("java.lang.Module", false, null);
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    public static byte[] transform(byte[] classBytes, String slashClassName, Class<?> targetClass) {
        if (InjectedClassHelper.isHelperClass(targetClass)) {
            return classBytes;
        }
        ClassFileTransformer transformer = ClassFileTransformerHolder.getClassFileTransformer();
        if (transformer != null) {
            try {
                byte[] result = IS_JAVA_9 ? Java9LambdaTransformer.transform((ClassFileTransformer)transformer, (byte[])classBytes, (String)slashClassName, targetClass) : transformer.transform(targetClass.getClassLoader(), slashClassName, null, null, classBytes);
                if (result != null) {
                    return result;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return classBytes;
    }
}

