/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.asynchttpclient.v2_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.asynchttpclient.v2_0.RequestContext;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.Request;
import org.asynchttpclient.netty.NettyResponseFuture;

public class NettyRequestSenderInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"org.asynchttpclient.netty.request.NettyRequestSender");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"sendRequest").and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.asynchttpclient.Request"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.asynchttpclient.AsyncHandler"))).and((ElementMatcher)ElementMatchers.isPublic()), NettyRequestSenderInstrumentation.class.getName() + "$AttachContextAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"writeRequest").and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.asynchttpclient.netty.NettyResponseFuture"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"io.netty.channel.Channel"))).and((ElementMatcher)ElementMatchers.isPublic()), NettyRequestSenderInstrumentation.class.getName() + "$MountContextAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"newNettyRequestAndResponseFuture").and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.asynchttpclient.Request"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.asynchttpclient.AsyncHandler"))).and((ElementMatcher)ElementMatchers.returns((ElementMatcher)ElementMatchers.named((String)"org.asynchttpclient.netty.NettyResponseFuture"))), NettyRequestSenderInstrumentation.class.getName() + "$RememberNettyRequestAdvice");
    }

    public static class RememberNettyRequestAdvice {
        @Advice.OnMethodExit
        public static void rememberNettyRequest(@Advice.Return NettyResponseFuture<?> responseFuture) {
            RequestContext requestContext = (RequestContext)VirtualField.find(AsyncHandler.class, RequestContext.class).get((Object)responseFuture.getAsyncHandler());
            if (requestContext != null) {
                requestContext.setNettyRequest(responseFuture.getNettyRequest());
            }
        }
    }

    public static class MountContextAdvice {
        @Advice.OnMethodEnter
        public static Scope mountContext(@Advice.Argument(value=0) NettyResponseFuture<?> responseFuture) {
            Request request = responseFuture.getCurrentRequest();
            Context context = (Context)VirtualField.find(Request.class, Context.class).get((Object)request);
            return context == null ? null : context.makeCurrent();
        }

        @Advice.OnMethodExit
        public static void unmountContext(@Advice.Enter Scope scope) {
            if (scope != null) {
                scope.close();
            }
        }
    }

    public static class AttachContextAdvice {
        @Advice.OnMethodEnter
        public static void attachContext(@Advice.Argument(value=0) Request request) {
            VirtualField.find(Request.class, Context.class).set((Object)request, (Object)Java8BytecodeBridge.currentContext());
        }
    }
}

