/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.asynchttpclient.v2_0;

import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.opentelemetry.instrumentation.api.instrumenter.net.InetSocketAddressNetClientAttributesGetter;
import io.opentelemetry.javaagent.instrumentation.asynchttpclient.v2_0.RequestContext;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;
import org.asynchttpclient.Response;
import org.asynchttpclient.netty.request.NettyRequest;

final class AsyncHttpClientNetAttributesGetter
extends InetSocketAddressNetClientAttributesGetter<RequestContext, Response> {
    AsyncHttpClientNetAttributesGetter() {
    }

    public String getTransport(RequestContext request, @Nullable Response response) {
        return "ip_tcp";
    }

    @Nullable
    public String getProtocolName(RequestContext request, @Nullable Response response) {
        HttpVersion httpVersion = AsyncHttpClientNetAttributesGetter.getHttpVersion(request);
        if (httpVersion == null) {
            return null;
        }
        return httpVersion.protocolName();
    }

    @Nullable
    public String getProtocolVersion(RequestContext request, @Nullable Response response) {
        HttpVersion httpVersion = AsyncHttpClientNetAttributesGetter.getHttpVersion(request);
        if (httpVersion == null) {
            return null;
        }
        return httpVersion.majorVersion() + "." + httpVersion.minorVersion();
    }

    @Nullable
    private static HttpVersion getHttpVersion(RequestContext request) {
        NettyRequest nettyRequest = request.getNettyRequest();
        if (nettyRequest == null) {
            return null;
        }
        HttpRequest httpRequest = nettyRequest.getHttpRequest();
        if (httpRequest == null) {
            return null;
        }
        return httpRequest.getProtocolVersion();
    }

    @Nullable
    public String getPeerName(RequestContext request) {
        return request.getRequest().getUri().getHost();
    }

    public Integer getPeerPort(RequestContext request) {
        return request.getRequest().getUri().getPort();
    }

    @Nullable
    protected InetSocketAddress getPeerSocketAddress(RequestContext request, @Nullable Response response) {
        if (response != null && response.getRemoteAddress() instanceof InetSocketAddress) {
            return (InetSocketAddress)response.getRemoteAddress();
        }
        return null;
    }
}

