/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.apachehttpclient.v5_0;

import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;

final class ApacheHttpClientNetAttributesGetter
implements NetClientAttributesGetter<HttpRequest, HttpResponse> {
    private static final Logger logger = Logger.getLogger(ApacheHttpClientNetAttributesGetter.class.getName());

    ApacheHttpClientNetAttributesGetter() {
    }

    public String transport(HttpRequest request, @Nullable HttpResponse response) {
        return "ip_tcp";
    }

    @Nullable
    public String peerName(HttpRequest request) {
        return request.getAuthority().getHostName();
    }

    public Integer peerPort(HttpRequest request) {
        int port = request.getAuthority().getPort();
        if (port != -1) {
            return port;
        }
        String scheme = request.getScheme();
        if (scheme == null) {
            return 80;
        }
        switch (scheme) {
            case "http": {
                return 80;
            }
            case "https": {
                return 443;
            }
        }
        logger.log(Level.FINE, "no default port mapping for scheme: {0}", scheme);
        return null;
    }
}

