/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.apachehttpclient.v5_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.apachehttpclient.v5_0.ApacheHttpClientSingletons;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;

class ApacheHttpAsyncClientInstrumentation
implements TypeInstrumentation {
    ApacheHttpAsyncClientInstrumentation() {
    }

    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return AgentElementMatchers.hasClassesNamed((String[])new String[]{"org.apache.hc.client5.http.async.HttpAsyncClient"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.implementsInterface((ElementMatcher)ElementMatchers.named((String)"org.apache.hc.client5.http.async.HttpAsyncClient"));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"execute")).and((ElementMatcher)ElementMatchers.takesArguments((int)5)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.nio.AsyncRequestProducer"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.nio.AsyncResponseConsumer"))).and((ElementMatcher)ElementMatchers.takesArgument((int)2, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.nio.HandlerFactory"))).and((ElementMatcher)ElementMatchers.takesArgument((int)3, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.http.protocol.HttpContext"))).and((ElementMatcher)ElementMatchers.takesArgument((int)4, (ElementMatcher)ElementMatchers.named((String)"org.apache.hc.core5.concurrent.FutureCallback"))), this.getClass().getName() + "$ClientAdvice");
    }

    public static class WrappedFutureCallback<T>
    implements FutureCallback<T> {
        private static final Logger logger = Logger.getLogger(WrappedFutureCallback.class.getName());
        private final Context parentContext;
        private final HttpContext httpContext;
        private final FutureCallback<T> delegate;
        private volatile Context context;
        private volatile HttpRequest httpRequest;

        public WrappedFutureCallback(Context parentContext, HttpContext httpContext, FutureCallback<T> delegate) {
            this.parentContext = parentContext;
            this.httpContext = httpContext;
            this.delegate = delegate;
        }

        public void completed(T result) {
            if (this.context == null) {
                logger.log(Level.FINE, "context was never set");
                this.completeDelegate(result);
                return;
            }
            ApacheHttpClientSingletons.instrumenter().end(this.context, (Object)this.httpRequest, (Object)this.getResponseFromHttpContext(), null);
            if (this.parentContext == null) {
                this.completeDelegate(result);
                return;
            }
            try (Scope ignored = this.parentContext.makeCurrent();){
                this.completeDelegate(result);
            }
        }

        public void failed(Exception ex) {
            if (this.context == null) {
                logger.log(Level.FINE, "context was never set");
                this.failDelegate(ex);
                return;
            }
            ApacheHttpClientSingletons.instrumenter().end(this.context, (Object)this.httpRequest, (Object)this.getResponseFromHttpContext(), (Throwable)ex);
            if (this.parentContext == null) {
                this.failDelegate(ex);
                return;
            }
            try (Scope ignored = this.parentContext.makeCurrent();){
                this.failDelegate(ex);
            }
        }

        public void cancelled() {
            if (this.context == null) {
                logger.log(Level.FINE, "context was never set");
                this.cancelDelegate();
                return;
            }
            ApacheHttpClientSingletons.instrumenter().end(this.context, (Object)this.httpRequest, (Object)this.getResponseFromHttpContext(), null);
            if (this.parentContext == null) {
                this.cancelDelegate();
                return;
            }
            try (Scope ignored = this.parentContext.makeCurrent();){
                this.cancelDelegate();
            }
        }

        private void completeDelegate(T result) {
            if (this.delegate != null) {
                this.delegate.completed(result);
            }
        }

        private void failDelegate(Exception ex) {
            if (this.delegate != null) {
                this.delegate.failed(ex);
            }
        }

        private void cancelDelegate() {
            if (this.delegate != null) {
                this.delegate.cancelled();
            }
        }

        @Nullable
        private HttpResponse getResponseFromHttpContext() {
            return (HttpResponse)this.httpContext.getAttribute("http.response");
        }
    }

    public static class DelegatingRequestChannel
    implements RequestChannel {
        private final RequestChannel delegate;
        private final Context parentContext;
        private final WrappedFutureCallback<?> wrappedFutureCallback;

        public DelegatingRequestChannel(RequestChannel requestChannel, Context parentContext, WrappedFutureCallback<?> wrappedFutureCallback) {
            this.delegate = requestChannel;
            this.parentContext = parentContext;
            this.wrappedFutureCallback = wrappedFutureCallback;
        }

        public void sendRequest(HttpRequest request, EntityDetails entityDetails, HttpContext context) throws HttpException, IOException {
            if (ApacheHttpClientSingletons.instrumenter().shouldStart(this.parentContext, (Object)request)) {
                ((WrappedFutureCallback)this.wrappedFutureCallback).context = ApacheHttpClientSingletons.instrumenter().start(this.parentContext, (Object)request);
                ((WrappedFutureCallback)this.wrappedFutureCallback).httpRequest = request;
            }
            this.delegate.sendRequest(request, entityDetails, context);
        }
    }

    public static class DelegatingRequestProducer
    implements AsyncRequestProducer {
        private final Context parentContext;
        private final AsyncRequestProducer delegate;
        private final WrappedFutureCallback<?> wrappedFutureCallback;

        public DelegatingRequestProducer(Context parentContext, AsyncRequestProducer delegate, WrappedFutureCallback<?> wrappedFutureCallback) {
            this.parentContext = parentContext;
            this.delegate = delegate;
            this.wrappedFutureCallback = wrappedFutureCallback;
        }

        public void failed(Exception ex) {
            this.delegate.failed(ex);
        }

        public void sendRequest(RequestChannel channel, HttpContext context) throws HttpException, IOException {
            DelegatingRequestChannel requestChannel = new DelegatingRequestChannel(channel, this.parentContext, this.wrappedFutureCallback);
            this.delegate.sendRequest((RequestChannel)requestChannel, context);
        }

        public boolean isRepeatable() {
            return this.delegate.isRepeatable();
        }

        public int available() {
            return this.delegate.available();
        }

        public void produce(DataStreamChannel channel) throws IOException {
            this.delegate.produce(channel);
        }

        public void releaseResources() {
            this.delegate.releaseResources();
        }
    }

    public static class ClientAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.Argument(value=0, readOnly=false) AsyncRequestProducer requestProducer, @Advice.Argument(value=3, readOnly=false) HttpContext httpContext, @Advice.Argument(value=4, readOnly=false) FutureCallback<?> futureCallback) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            if (httpContext == null) {
                httpContext = new BasicHttpContext();
            }
            WrappedFutureCallback wrappedFutureCallback = new WrappedFutureCallback(parentContext, httpContext, futureCallback);
            requestProducer = new DelegatingRequestProducer(parentContext, requestProducer, wrappedFutureCallback);
            futureCallback = wrappedFutureCallback;
        }
    }
}

