/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.akkahttp.server;

import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteHolder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.javaagent.bootstrap.internal.CommonConfig;
import io.opentelemetry.javaagent.instrumentation.akkahttp.AkkaHttpUtil;
import io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter;
import io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerHeaders;
import io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaNetServerAttributesGetter;

public final class AkkaHttpServerSingletons {
    private static final Instrumenter<HttpRequest, HttpResponse> INSTRUMENTER;

    public static Instrumenter<HttpRequest, HttpResponse> instrumenter() {
        return INSTRUMENTER;
    }

    public static HttpResponse errorResponse() {
        return (HttpResponse)HttpResponse.create().withStatus(500);
    }

    private AkkaHttpServerSingletons() {
    }

    static {
        AkkaHttpServerAttributesGetter httpAttributesGetter = new AkkaHttpServerAttributesGetter();
        INSTRUMENTER = Instrumenter.builder((OpenTelemetry)GlobalOpenTelemetry.get(), (String)AkkaHttpUtil.instrumentationName(), (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)httpAttributesGetter)).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)httpAttributesGetter)).addAttributesExtractor((AttributesExtractor)HttpServerAttributesExtractor.builder((HttpServerAttributesGetter)httpAttributesGetter, (NetServerAttributesGetter)new AkkaNetServerAttributesGetter()).setCapturedRequestHeaders(CommonConfig.get().getServerRequestHeaders()).setCapturedResponseHeaders(CommonConfig.get().getServerResponseHeaders()).build()).addOperationMetrics(HttpServerMetrics.get()).addContextCustomizer(HttpRouteHolder.get()).buildServerInstrumenter((TextMapGetter)AkkaHttpServerHeaders.INSTANCE);
    }
}

