/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.akkahttp.server;

import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import com.google.auto.service.AutoService;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerSingletons;
import io.opentelemetry.javaagent.instrumentation.akkahttp.server.HttpExtServerInstrumentation;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationModuleMuzzle;
import io.opentelemetry.javaagent.tooling.muzzle.VirtualFieldMappingsBuilder;
import io.opentelemetry.javaagent.tooling.muzzle.references.ClassRef;
import io.opentelemetry.javaagent.tooling.muzzle.references.Flag;
import io.opentelemetry.javaagent.tooling.muzzle.references.Source;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.AbstractFunction1;

@AutoService(value={InstrumentationModule.class})
public class AkkaHttpServerInstrumentationModule
extends InstrumentationModule
implements InstrumentationModuleMuzzle {
    public AkkaHttpServerInstrumentationModule() {
        super("akka-http", new String[]{"akka-http-server"});
    }

    public List<TypeInstrumentation> typeInstrumentations() {
        return Collections.singletonList(new HttpExtServerInstrumentation());
    }

    public Map getMuzzleReferences() {
        HashMap<String, ClassRef> hashMap = new HashMap<String, ClassRef>(27, 0.75f);
        hashMap.put("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", ClassRef.builder((String)"io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.HttpExtServerInstrumentation$AkkaHttpAsyncAdvice", 63).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.HttpExtServerInstrumentation$AkkaHttpAsyncAdvice", 65).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 0).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 69).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 70).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 77).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 81).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 82).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 62).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1", 84).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2", 91).addFlag((Flag)Flag.MinimumVisibilityFlag.PACKAGE_OR_HIGHER).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.ManifestationFlag.NON_FINAL).addFlag((Flag)Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER).setSuperClassName("scala.runtime.AbstractFunction1").addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 69), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 77), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 81)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.NON_STATIC}, "userHandler", Type.getType((String)"Lscala/Function1;"), true).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 70), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 82)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.NON_STATIC}, "executionContext", Type.getType((String)"Lscala/concurrent/ExecutionContext;"), true).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 62)}, new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL, Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER}, "apply", Type.getType((String)"Lscala/concurrent/Future;"), new Type[]{Type.getType((String)"Lakka/http/scaladsl/model/HttpRequest;")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "apply", Type.getType((String)"Ljava/lang/Object;"), new Type[]{Type.getType((String)"Ljava/lang/Object;")}).build());
        hashMap.put("scala.concurrent.ExecutionContextExecutor", ClassRef.builder((String)"scala.concurrent.ExecutionContextExecutor").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.HttpExtServerInstrumentation$AkkaHttpAsyncAdvice", 65).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("akka.stream.Materializer", ClassRef.builder((String)"akka.stream.Materializer").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.HttpExtServerInstrumentation$AkkaHttpAsyncAdvice", 65).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.HttpExtServerInstrumentation$AkkaHttpAsyncAdvice", 65)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "executionContext", Type.getType((String)"Lscala/concurrent/ExecutionContextExecutor;"), new Type[0]).build());
        hashMap.put("scala.Function1", ClassRef.builder((String)"scala.Function1").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.HttpExtServerInstrumentation$AkkaHttpAsyncAdvice", 65).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 69).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 77).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 81).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 82).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 83).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.HttpExtServerInstrumentation$AkkaHttpSyncAdvice", 51).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 41).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 48).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 52).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 77), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 82), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 48), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 52)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "apply", Type.getType((String)"Ljava/lang/Object;"), new Type[]{Type.getType((String)"Ljava/lang/Object;")}).build());
        hashMap.put("scala.concurrent.ExecutionContext", ClassRef.builder((String)"scala.concurrent.ExecutionContext").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.HttpExtServerInstrumentation$AkkaHttpAsyncAdvice", 65).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 70).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 82).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 83).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("scala.runtime.AbstractFunction1", ClassRef.builder((String)"scala.runtime.AbstractFunction1").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 0).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 68).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1", 0).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1", 84).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2", 0).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2", 91).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 0).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 40).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 68), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1", 84), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2", 91), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 40)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "<init>", Type.getType((String)"V"), new Type[0]).build());
        hashMap.put("scala.concurrent.Future", ClassRef.builder((String)"scala.concurrent.Future").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 77).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 82).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 83).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 62).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 83)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "transform", Type.getType((String)"Lscala/concurrent/Future;"), new Type[]{Type.getType((String)"Lscala/Function1;"), Type.getType((String)"Lscala/Function1;"), Type.getType((String)"Lscala/concurrent/ExecutionContext;")}).build());
        hashMap.put("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1", ClassRef.builder((String)"io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 82).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1", 0).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1", 84).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1", 87).addFlag((Flag)Flag.MinimumVisibilityFlag.PACKAGE_OR_HIGHER).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.ManifestationFlag.NON_FINAL).addFlag((Flag)Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER).setSuperClassName("scala.runtime.AbstractFunction1").addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1", 84), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1", 87)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.NON_STATIC}, "val$context", Type.getType((String)"Lio/opentelemetry/context/Context;"), true).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1", 84), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1", 87)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.NON_STATIC}, "val$request", Type.getType((String)"Lakka/http/scaladsl/model/HttpRequest;"), true).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1", 84)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.NON_STATIC}, "this$0", Type.getType((String)"Lio/opentelemetry/javaagent/instrumentation/akkahttp/server/AkkaHttpServerInstrumentationModule$AsyncWrapper;"), true).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1", 84)}, new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL, Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER}, "apply", Type.getType((String)"Lakka/http/scaladsl/model/HttpResponse;"), new Type[]{Type.getType((String)"Lakka/http/scaladsl/model/HttpResponse;")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "apply", Type.getType((String)"Ljava/lang/Object;"), new Type[]{Type.getType((String)"Ljava/lang/Object;")}).build());
        hashMap.put("akka.http.scaladsl.model.HttpRequest", ClassRef.builder((String)"akka.http.scaladsl.model.HttpRequest").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 82).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 62).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1", 84).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1", 87).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2", 91).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2", 94).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 21).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 26).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 42).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 47).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 48).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 63).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 16).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.AkkaHttpUtil", 24).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.AkkaHttpUtil", 37).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaNetServerAttributesGetter", 13).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerHeaders", 20).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerHeaders", 27).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerHeaders", 15).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 37).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 21)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "method", Type.getType((String)"Lakka/http/scaladsl/model/HttpMethod;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 47), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 48), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 63)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "uri", Type.getType((String)"Lakka/http/scaladsl/model/Uri;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.AkkaHttpUtil", 24), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerHeaders", 27)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeader", Type.getType((String)"Ljava/util/Optional;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.AkkaHttpUtil", 37)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "protocol", Type.getType((String)"Lakka/http/scaladsl/model/HttpProtocol;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerHeaders", 20)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeaders", Type.getType((String)"Ljava/lang/Iterable;"), new Type[0]).build());
        hashMap.put("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2", ClassRef.builder((String)"io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper", 82).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2", 0).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2", 91).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2", 94).addFlag((Flag)Flag.MinimumVisibilityFlag.PACKAGE_OR_HIGHER).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.ManifestationFlag.NON_FINAL).addFlag((Flag)Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER).setSuperClassName("scala.runtime.AbstractFunction1").addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2", 91), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2", 94)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.NON_STATIC}, "val$context", Type.getType((String)"Lio/opentelemetry/context/Context;"), true).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2", 91), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2", 94)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.NON_STATIC}, "val$request", Type.getType((String)"Lakka/http/scaladsl/model/HttpRequest;"), true).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2", 91)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.NON_STATIC}, "this$0", Type.getType((String)"Lio/opentelemetry/javaagent/instrumentation/akkahttp/server/AkkaHttpServerInstrumentationModule$AsyncWrapper;"), true).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2", 91)}, new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL, Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER}, "apply", Type.getType((String)"Ljava/lang/Throwable;"), new Type[]{Type.getType((String)"Ljava/lang/Throwable;")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "apply", Type.getType((String)"Ljava/lang/Object;"), new Type[]{Type.getType((String)"Ljava/lang/Object;")}).build());
        hashMap.put("akka.http.javadsl.model.HttpResponse", ClassRef.builder((String)"akka.http.javadsl.model.HttpResponse").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerSingletons", 48).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerSingletons", 48)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "withStatus", Type.getType((String)"Lakka/http/javadsl/model/HttpResponse;"), new Type[]{Type.getType((String)"I")}).build());
        hashMap.put("akka.http.scaladsl.model.HttpResponse", ClassRef.builder((String)"akka.http.scaladsl.model.HttpResponse").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerSingletons", 48).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1", 84).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2", 94).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 32).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 37).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 16).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.AkkaHttpUtil", 31).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 48).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 52).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 56).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 37).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerSingletons", 48)}, new Flag[]{Flag.OwnershipFlag.STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "create", Type.getType((String)"Lakka/http/javadsl/model/HttpResponse;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 32)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "status", Type.getType((String)"Lakka/http/scaladsl/model/StatusCode;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.AkkaHttpUtil", 31)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeader", Type.getType((String)"Ljava/util/Optional;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).build());
        hashMap.put("akka.http.scaladsl.model.HttpMethod", ClassRef.builder((String)"akka.http.scaladsl.model.HttpMethod").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 21).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 21)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "value", Type.getType((String)"Ljava/lang/String;"), new Type[0]).build());
        hashMap.put("akka.http.scaladsl.model.StatusCode", ClassRef.builder((String)"akka.http.scaladsl.model.StatusCode").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 32).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 32)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "intValue", Type.getType((String)"I"), new Type[0]).build());
        hashMap.put("akka.http.scaladsl.model.Uri", ClassRef.builder((String)"akka.http.scaladsl.model.Uri").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 47).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 48).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 63).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 47)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "path", Type.getType((String)"Lakka/http/scaladsl/model/Uri$Path;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 48)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "rawQueryString", Type.getType((String)"Lscala/Option;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 63)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "scheme", Type.getType((String)"Ljava/lang/String;"), new Type[0]).build());
        hashMap.put("akka.http.scaladsl.model.Uri$Path", ClassRef.builder((String)"akka.http.scaladsl.model.Uri$Path").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 47).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 47)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "toString", Type.getType((String)"Ljava/lang/String;"), new Type[0]).build());
        hashMap.put("scala.Option", ClassRef.builder((String)"scala.Option").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 48).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 49).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 50).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 49)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "isDefined", Type.getType((String)"Z"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter", 50)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "get", Type.getType((String)"Ljava/lang/Object;"), new Type[0]).build());
        hashMap.put("akka.http.scaladsl.model.HttpProtocol", ClassRef.builder((String)"akka.http.scaladsl.model.HttpProtocol").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.AkkaHttpUtil", 37).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.AkkaHttpUtil", 37)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "value", Type.getType((String)"Ljava/lang/String;"), new Type[0]).build());
        hashMap.put("akka.http.javadsl.model.HttpHeader", ClassRef.builder((String)"akka.http.javadsl.model.HttpHeader").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.AkkaHttpUtil", 32).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.AkkaHttpUtil", 25).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerHeaders", 20).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerHeaders", 28).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.AkkaHttpUtil", 32), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.AkkaHttpUtil", 25), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerHeaders", 28)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "value", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerHeaders", 20)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "lowercaseName", Type.getType((String)"Ljava/lang/String;"), new Type[0]).build());
        hashMap.put("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", ClassRef.builder((String)"io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper").addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.HttpExtServerInstrumentation$AkkaHttpSyncAdvice", 51).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 0).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 41).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 48).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 52).addSource("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 37).addFlag((Flag)Flag.MinimumVisibilityFlag.PACKAGE_OR_HIGHER).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.ManifestationFlag.NON_FINAL).addFlag((Flag)Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER).setSuperClassName("scala.runtime.AbstractFunction1").addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 41), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 48), new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 52)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.NON_STATIC}, "userHandler", Type.getType((String)"Lscala/Function1;"), true).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper", 37)}, new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL, Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER}, "apply", Type.getType((String)"Lakka/http/scaladsl/model/HttpResponse;"), new Type[]{Type.getType((String)"Lakka/http/scaladsl/model/HttpRequest;")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "apply", Type.getType((String)"Ljava/lang/Object;"), new Type[]{Type.getType((String)"Ljava/lang/Object;")}).build());
        return hashMap;
    }

    public List getMuzzleHelperClassNames() {
        ArrayList<String> arrayList = new ArrayList<String>(9);
        arrayList.add("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$2");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$AsyncWrapper$1");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerSingletons");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerAttributesGetter");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaNetServerAttributesGetter");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerHeaders");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.akkahttp.AkkaHttpUtil");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.akkahttp.server.AkkaHttpServerInstrumentationModule$SyncWrapper");
        return arrayList;
    }

    public void registerMuzzleVirtualFields(VirtualFieldMappingsBuilder virtualFieldMappingsBuilder) {
    }

    public static class AsyncWrapper
    extends AbstractFunction1<HttpRequest, Future<HttpResponse>> {
        private final Function1<HttpRequest, Future<HttpResponse>> userHandler;
        private final ExecutionContext executionContext;

        public AsyncWrapper(Function1<HttpRequest, Future<HttpResponse>> userHandler, ExecutionContext executionContext) {
            this.userHandler = userHandler;
            this.executionContext = executionContext;
        }

        public Future<HttpResponse> apply(final HttpRequest request) {
            Future future;
            block9: {
                Context parentContext = Java8BytecodeBridge.currentContext();
                if (!AkkaHttpServerSingletons.instrumenter().shouldStart(parentContext, (Object)request)) {
                    return (Future)this.userHandler.apply((Object)request);
                }
                final Context context = AkkaHttpServerSingletons.instrumenter().start(parentContext, (Object)request);
                Scope ignored = context.makeCurrent();
                try {
                    future = ((Future)this.userHandler.apply((Object)request)).transform((Function1)new AbstractFunction1<HttpResponse, HttpResponse>(){

                        public HttpResponse apply(HttpResponse response) {
                            AkkaHttpServerSingletons.instrumenter().end(context, (Object)request, (Object)response, null);
                            return response;
                        }
                    }, (Function1)new AbstractFunction1<Throwable, Throwable>(){

                        public Throwable apply(Throwable t) {
                            AkkaHttpServerSingletons.instrumenter().end(context, (Object)request, (Object)AkkaHttpServerSingletons.errorResponse(), t);
                            return t;
                        }
                    }, this.executionContext);
                    if (ignored == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        AkkaHttpServerSingletons.instrumenter().end(context, (Object)request, null, t);
                        throw t;
                    }
                }
                ignored.close();
            }
            return future;
        }
    }

    public static class SyncWrapper
    extends AbstractFunction1<HttpRequest, HttpResponse> {
        private final Function1<HttpRequest, HttpResponse> userHandler;

        public SyncWrapper(Function1<HttpRequest, HttpResponse> userHandler) {
            this.userHandler = userHandler;
        }

        public HttpResponse apply(HttpRequest request) {
            HttpResponse httpResponse;
            block9: {
                Context parentContext = Java8BytecodeBridge.currentContext();
                if (!AkkaHttpServerSingletons.instrumenter().shouldStart(parentContext, (Object)request)) {
                    return (HttpResponse)this.userHandler.apply((Object)request);
                }
                Context context = AkkaHttpServerSingletons.instrumenter().start(parentContext, (Object)request);
                Scope ignored = context.makeCurrent();
                try {
                    HttpResponse response = (HttpResponse)this.userHandler.apply((Object)request);
                    AkkaHttpServerSingletons.instrumenter().end(context, (Object)request, (Object)response, null);
                    httpResponse = response;
                    if (ignored == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        AkkaHttpServerSingletons.instrumenter().end(context, (Object)request, (Object)AkkaHttpServerSingletons.errorResponse(), t);
                        throw t;
                    }
                }
                ignored.close();
            }
            return httpResponse;
        }
    }
}

