/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.akkahttp.server;

import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.javaagent.instrumentation.akkahttp.AkkaHttpUtil;
import java.util.List;
import javax.annotation.Nullable;
import scala.Option;

class AkkaHttpServerAttributesGetter
implements HttpServerAttributesGetter<HttpRequest, HttpResponse> {
    AkkaHttpServerAttributesGetter() {
    }

    public String method(HttpRequest request) {
        return request.method().value();
    }

    public List<String> requestHeader(HttpRequest request, String name) {
        return AkkaHttpUtil.requestHeader(request, name);
    }

    public Integer statusCode(HttpRequest request, HttpResponse httpResponse, @Nullable Throwable error) {
        return httpResponse.status().intValue();
    }

    public List<String> responseHeader(HttpRequest request, HttpResponse httpResponse, String name) {
        return AkkaHttpUtil.responseHeader(httpResponse, name);
    }

    public String flavor(HttpRequest request) {
        return AkkaHttpUtil.flavor(request);
    }

    public String target(HttpRequest request) {
        String target = request.uri().path().toString();
        Option queryString = request.uri().rawQueryString();
        if (queryString.isDefined()) {
            target = target + "?" + (String)queryString.get();
        }
        return target;
    }

    @Nullable
    public String route(HttpRequest request) {
        return null;
    }

    public String scheme(HttpRequest request) {
        return request.uri().scheme();
    }
}

