/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.akkahttp.client;

import akka.http.javadsl.model.HttpHeader;
import akka.http.javadsl.model.headers.RawHeader;
import akka.http.scaladsl.model.HttpRequest;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapSetter;

public class HttpHeaderSetter
implements TextMapSetter<AkkaHttpHeaders> {
    private final ContextPropagators contextPropagators;

    public HttpHeaderSetter(ContextPropagators contextPropagators) {
        this.contextPropagators = contextPropagators;
    }

    public void set(AkkaHttpHeaders carrier, String key, String value) {
        HttpRequest request = carrier.getRequest();
        if (request != null) {
            carrier.setRequest((HttpRequest)request.removeHeader(key).addHeader((HttpHeader)RawHeader.create((String)key, (String)value)));
        }
    }

    public HttpRequest inject(HttpRequest original) {
        AkkaHttpHeaders carrier = new AkkaHttpHeaders(original);
        this.contextPropagators.getTextMapPropagator().inject(Context.current(), (Object)carrier, (TextMapSetter)this);
        return carrier.getRequest();
    }

    static class AkkaHttpHeaders {
        private HttpRequest request;

        public AkkaHttpHeaders(HttpRequest request) {
            this.request = request;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void setRequest(HttpRequest request) {
            this.request = request;
        }
    }
}

