/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.akkahttp.client;

import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.akkahttp.client.AkkaHttpClientSingletons;
import io.opentelemetry.javaagent.instrumentation.akkahttp.client.FutureWrapper;
import io.opentelemetry.javaagent.instrumentation.akkahttp.client.OnCompleteHandler;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public class HttpExtClientInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"akka.http.scaladsl.HttpExt");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"singleRequest").and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"akka.http.scaladsl.model.HttpRequest"))), this.getClass().getName() + "$SingleRequestAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"singleRequestImpl").and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"akka.http.scaladsl.model.HttpRequest"))), this.getClass().getName() + "$SingleRequestAdvice");
    }

    public static class SingleRequestAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.Argument(value=0, readOnly=false) HttpRequest request, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            if (!AkkaHttpClientSingletons.instrumenter().shouldStart(parentContext, (Object)request)) {
                return;
            }
            context = AkkaHttpClientSingletons.instrumenter().start(parentContext, (Object)request);
            scope = context.makeCurrent();
            request = AkkaHttpClientSingletons.setter().inject(request);
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Argument(value=0) HttpRequest request, @Advice.This HttpExt thiz, @Advice.Return(readOnly=false) Future<HttpResponse> responseFuture, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            if (throwable == null) {
                responseFuture.onComplete((Function1)new OnCompleteHandler(context, request), (ExecutionContext)thiz.system().dispatcher());
            } else {
                AkkaHttpClientSingletons.instrumenter().end(context, (Object)request, null, throwable);
            }
            if (responseFuture != null) {
                responseFuture = FutureWrapper.wrap(responseFuture, (ExecutionContext)thiz.system().dispatcher(), Java8BytecodeBridge.currentContext());
            }
        }
    }
}

