/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.akkahttp.client;

import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.net.PeerServiceAttributesExtractor;
import io.opentelemetry.javaagent.bootstrap.internal.CommonConfig;
import io.opentelemetry.javaagent.instrumentation.akkahttp.AkkaHttpUtil;
import io.opentelemetry.javaagent.instrumentation.akkahttp.client.AkkaHttpClientAttributesGetter;
import io.opentelemetry.javaagent.instrumentation.akkahttp.client.AkkaHttpNetAttributesGetter;
import io.opentelemetry.javaagent.instrumentation.akkahttp.client.HttpHeaderSetter;
import java.util.Map;

public class AkkaHttpClientSingletons {
    private static final HttpHeaderSetter SETTER = new HttpHeaderSetter(GlobalOpenTelemetry.getPropagators());
    private static final Instrumenter<HttpRequest, HttpResponse> INSTRUMENTER;

    public static Instrumenter<HttpRequest, HttpResponse> instrumenter() {
        return INSTRUMENTER;
    }

    public static HttpHeaderSetter setter() {
        return SETTER;
    }

    private AkkaHttpClientSingletons() {
    }

    static {
        AkkaHttpClientAttributesGetter httpAttributesGetter = new AkkaHttpClientAttributesGetter();
        AkkaHttpNetAttributesGetter netAttributesGetter = new AkkaHttpNetAttributesGetter();
        INSTRUMENTER = Instrumenter.builder((OpenTelemetry)GlobalOpenTelemetry.get(), (String)AkkaHttpUtil.instrumentationName(), (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)httpAttributesGetter)).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addAttributesExtractor((AttributesExtractor)HttpClientAttributesExtractor.builder((HttpClientAttributesGetter)httpAttributesGetter).setCapturedRequestHeaders(CommonConfig.get().getClientRequestHeaders()).setCapturedResponseHeaders(CommonConfig.get().getClientResponseHeaders()).build()).addAttributesExtractor((AttributesExtractor)NetClientAttributesExtractor.create((NetClientAttributesGetter)netAttributesGetter)).addAttributesExtractor((AttributesExtractor)PeerServiceAttributesExtractor.create((NetClientAttributesGetter)netAttributesGetter, (Map)CommonConfig.get().getPeerServiceMapping())).addOperationMetrics(HttpClientMetrics.get()).buildInstrumenter(SpanKindExtractor.alwaysClient());
    }
}

