// AUTOGENERATED FILE - DO NOT MODIFY!
// This file generated by Djinni from error_manager.djinni

package io.openmobilemaps.mapscore.shared.map

import java.util.concurrent.atomic.AtomicBoolean

abstract class ErrorManager {

    abstract fun addTiledLayerError(error: TiledLayerError)

    abstract fun removeError(url: String)

    abstract fun clearAllErrors()

    abstract fun addErrorListener(listener: ErrorManagerListener)

    abstract fun removeErrorListener(listener: ErrorManagerListener)

    companion object {
        @JvmStatic
        fun create(): ErrorManager {
            return CppProxy.create()
        }
    }

    private class CppProxy : ErrorManager {
        private val nativeRef: Long
        private val destroyed: AtomicBoolean = AtomicBoolean(false)

        private constructor(nativeRef: Long) {
            if (nativeRef == 0L) error("nativeRef is zero")
            this.nativeRef = nativeRef
        }

        private external fun nativeDestroy(nativeRef: Long)
        fun _djinni_private_destroy() {
            val destroyed = this.destroyed.getAndSet(true)
            if (!destroyed) nativeDestroy(this.nativeRef)
        }
        protected fun finalize() {
            _djinni_private_destroy()
        }

        override fun addTiledLayerError(error: TiledLayerError) {
            assert(!this.destroyed.get()) { error("trying to use a destroyed object") }
            native_addTiledLayerError(this.nativeRef, error)
        }
        private external fun native_addTiledLayerError(_nativeRef: Long, error: TiledLayerError)

        override fun removeError(url: String) {
            assert(!this.destroyed.get()) { error("trying to use a destroyed object") }
            native_removeError(this.nativeRef, url)
        }
        private external fun native_removeError(_nativeRef: Long, url: String)

        override fun clearAllErrors() {
            assert(!this.destroyed.get()) { error("trying to use a destroyed object") }
            native_clearAllErrors(this.nativeRef)
        }
        private external fun native_clearAllErrors(_nativeRef: Long)

        override fun addErrorListener(listener: ErrorManagerListener) {
            assert(!this.destroyed.get()) { error("trying to use a destroyed object") }
            native_addErrorListener(this.nativeRef, listener)
        }
        private external fun native_addErrorListener(_nativeRef: Long, listener: ErrorManagerListener)

        override fun removeErrorListener(listener: ErrorManagerListener) {
            assert(!this.destroyed.get()) { error("trying to use a destroyed object") }
            native_removeErrorListener(this.nativeRef, listener)
        }
        private external fun native_removeErrorListener(_nativeRef: Long, listener: ErrorManagerListener)

        companion object {
            @JvmStatic
            external fun create(): ErrorManager
        }
    }
}
