/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.command;

import com.alibaba.fastjson.JSON;
import com.beust.jcommander.JCommander;
import io.openmessaging.storage.dledger.DLedgerConfig;
import io.openmessaging.storage.dledger.command.ConfigCommand;
import io.openmessaging.storage.dledger.proxy.DLedgerProxy;
import io.openmessaging.storage.dledger.proxy.DLedgerProxyConfig;
import io.openmessaging.storage.dledger.proxy.util.ConfigUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLedger {
    private static Logger logger = LoggerFactory.getLogger(DLedger.class);

    public static void main(String[] args) {
        LinkedList<DLedgerConfig> dLedgerConfigs = new LinkedList<DLedgerConfig>();
        if (args.length > 0 && ("--config".equals(args[0]) || "-c".equals(args[0]))) {
            ConfigCommand configCommand = new ConfigCommand();
            JCommander.newBuilder().addObject((Object)configCommand).build().parse(args);
            try {
                DLedgerProxyConfig dLedgerProxyConfig = ConfigUtils.parseDLedgerProxyConfig((String)configCommand.getConfigPath());
                dLedgerConfigs.addAll(dLedgerProxyConfig.getConfigs());
            }
            catch (Exception e) {
                logger.error("Create DLedgerProxyConfig error", (Throwable)e);
                System.exit(-1);
            }
        } else {
            DLedgerConfig dLedgerConfig = new DLedgerConfig();
            JCommander.newBuilder().addObject((Object)dLedgerConfig).build().parse(args);
            dLedgerConfigs.add(dLedgerConfig);
        }
        DLedger.bootstrapDLedger(dLedgerConfigs);
    }

    public static void bootstrapDLedger(List<DLedgerConfig> dLedgerConfigs) {
        if (dLedgerConfigs == null || dLedgerConfigs.isEmpty()) {
            logger.error("Bootstrap DLedger server error", (Throwable)new IllegalArgumentException("DLedgerConfigs is null or empty"));
        }
        final DLedgerProxy dLedgerProxy = new DLedgerProxy(dLedgerConfigs);
        dLedgerProxy.startup();
        logger.info("DLedgers start ok with config {}", (Object)JSON.toJSONString(dLedgerConfigs));
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){
            private volatile boolean hasShutdown = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    logger.info("Shutdown hook was invoked");
                    if (!this.hasShutdown) {
                        this.hasShutdown = true;
                        long beginTime = System.currentTimeMillis();
                        dLedgerProxy.shutdown();
                        long consumingTimeTotal = System.currentTimeMillis() - beginTime;
                        logger.info("Shutdown hook over, consuming total time(ms): {}", (Object)consumingTimeTotal);
                    }
                }
            }
        }, "ShutdownHook"));
    }

    public static void bootstrapDLedger(DLedgerConfig dLedgerConfig) {
        DLedger.bootstrapDLedger(Collections.singletonList(dLedgerConfig));
    }
}

