/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.chaos.driver.rocketmq;

import io.openmessaging.chaos.common.InvokeResult;
import io.openmessaging.chaos.driver.mq.MQChaosProducer;
import java.util.List;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQChaosProducer
implements MQChaosProducer {
    private static final Logger log = LoggerFactory.getLogger(RocketMQChaosProducer.class);
    private final DefaultMQProducer defaultMQProducer;
    private String chaosTopic;

    public RocketMQChaosProducer(DefaultMQProducer defaultMQProducer, String chaosTopic) {
        this.defaultMQProducer = defaultMQProducer;
        this.chaosTopic = chaosTopic;
    }

    public InvokeResult enqueue(byte[] payload) {
        Message message = new Message(this.chaosTopic, payload);
        SendResult sendResult = null;
        try {
            sendResult = this.defaultMQProducer.send(message);
        }
        catch (RemotingException e) {
            if (e instanceof RemotingConnectException || e instanceof RemotingSendRequestException) {
                log.warn("Enqueue fail", (Throwable)e);
                return InvokeResult.FAILURE;
            }
            log.warn("Enqueue unknown", (Throwable)e);
            return InvokeResult.UNKNOWN;
        }
        catch (IllegalStateException | InterruptedException | MQBrokerException | MQClientException e) {
            log.warn("Enqueue fail", e);
            return InvokeResult.FAILURE;
        }
        catch (Exception e) {
            log.warn("Enqueue unknown", (Throwable)e);
            return InvokeResult.UNKNOWN;
        }
        return InvokeResult.SUCCESS.setExtraInfoAndReturnSelf(sendResult.toString());
    }

    public InvokeResult enqueue(String shardingKey, byte[] payload) {
        Message message = new Message(this.chaosTopic, payload);
        message.setKeys(shardingKey);
        SendResult sendResult = null;
        try {
            sendResult = this.defaultMQProducer.send(message, new MessageQueueSelector(){

                public MessageQueue select(List<MessageQueue> mqs, Message msg, Object arg) {
                    String key = (String)arg;
                    int index = Math.abs(key.hashCode()) % mqs.size();
                    return mqs.get(index);
                }
            }, (Object)shardingKey);
        }
        catch (RemotingException e) {
            if (e instanceof RemotingConnectException || e instanceof RemotingSendRequestException) {
                log.warn("Enqueue fail", (Throwable)e);
                return InvokeResult.FAILURE;
            }
            log.warn("Enqueue unknown", (Throwable)e);
            return InvokeResult.UNKNOWN;
        }
        catch (IllegalStateException | InterruptedException | MQBrokerException | MQClientException e) {
            log.warn("Enqueue fail", e);
            return InvokeResult.FAILURE;
        }
        catch (Exception e) {
            log.warn("Enqueue unknown", (Throwable)e);
            return InvokeResult.UNKNOWN;
        }
        return InvokeResult.SUCCESS.setExtraInfoAndReturnSelf(sendResult.toString());
    }

    public void start() {
        try {
            if (this.defaultMQProducer != null) {
                this.defaultMQProducer.start();
            }
        }
        catch (MQClientException e) {
            log.error("Failed to start the created producer instance.", (Throwable)e);
        }
    }

    public void close() {
        if (this.defaultMQProducer != null) {
            this.defaultMQProducer.shutdown();
        }
    }
}

