/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.chaos.driver.rocketmq;

import com.google.common.collect.Lists;
import io.openmessaging.chaos.common.Message;
import io.openmessaging.chaos.driver.mq.MQChaosPullConsumer;
import java.util.List;
import org.apache.rocketmq.client.consumer.DefaultLitePullConsumer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQChaosPullConsumer
implements MQChaosPullConsumer {
    private static final Logger log = LoggerFactory.getLogger(RocketMQChaosPullConsumer.class);
    private DefaultLitePullConsumer defaultLitePullConsumer;

    public RocketMQChaosPullConsumer(DefaultLitePullConsumer defaultLitePullConsumer) {
        this.defaultLitePullConsumer = defaultLitePullConsumer;
    }

    public List<Message> dequeue() {
        List messages = this.defaultLitePullConsumer.poll();
        if (!messages.isEmpty()) {
            this.defaultLitePullConsumer.commitSync();
            return Lists.transform((List)messages, messageExt -> new Message(messageExt.getKeys(), messageExt.getBody()));
        }
        return null;
    }

    public void start() {
        try {
            if (this.defaultLitePullConsumer != null) {
                this.defaultLitePullConsumer.start();
            }
        }
        catch (MQClientException e) {
            log.error("Failed to start the RocketMQChaosPullConsumer instance.", (Throwable)e);
        }
    }

    public void close() {
        if (this.defaultLitePullConsumer != null) {
            this.defaultLitePullConsumer.shutdown();
        }
    }
}

