/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.chaos.driver.rocketmq;

import io.openmessaging.chaos.common.utils.KillProcessUtil;
import io.openmessaging.chaos.common.utils.PauseProcessUtil;
import io.openmessaging.chaos.common.utils.SshUtil;
import io.openmessaging.chaos.driver.mq.MQChaosNode;
import io.openmessaging.chaos.driver.rocketmq.config.RocketMQBrokerConfig;
import io.openmessaging.chaos.driver.rocketmq.config.RocketMQConfig;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQChaosNode
implements MQChaosNode {
    private static final String BROKER_PROCESS_NAME = "org.apache.rocketmq.broker.BrokerStartup";
    private static final String NAMESERVER_PROCESS_NAME = "org.apache.rocketmq.namesrv.NamesrvStartup";
    private static final Logger log = LoggerFactory.getLogger(RocketMQChaosNode.class);
    private String node;
    private List<String> nodes;
    private RocketMQBrokerConfig rmqBrokerConfig;
    private String installDir = "rocketmq-chaos-test";
    private String rocketmqVersion = "4.6.0";
    private String configureFilePath = "broker-chaos-test.conf";

    public RocketMQChaosNode(String node, List<String> nodes, RocketMQConfig rmqConfig, RocketMQBrokerConfig rmqBrokerConfig) {
        this.node = node;
        this.nodes = nodes;
        this.rmqBrokerConfig = rmqBrokerConfig;
        if (rmqConfig.installDir != null && !rmqConfig.installDir.isEmpty()) {
            this.installDir = rmqConfig.installDir;
        }
        if (rmqConfig.rocketmqVersion != null && !rmqConfig.rocketmqVersion.isEmpty()) {
            this.rocketmqVersion = rmqConfig.rocketmqVersion;
        }
        if (rmqConfig.configureFilePath != null && !rmqConfig.configureFilePath.isEmpty()) {
            this.configureFilePath = rmqConfig.configureFilePath;
        }
    }

    public void setup() {
        try {
            log.info("Node {} download rocketmq...", (Object)this.node);
            SshUtil.execCommand((String)this.node, (String)String.format("rm -rf %s; mkdir %s", this.installDir, this.installDir));
            SshUtil.execCommandInDir((String)this.node, (String)this.installDir, (String[])new String[]{String.format("curl https://archive.apache.org/dist/rocketmq/%s/rocketmq-all-%s-bin-release.zip -o rocketmq.zip", this.rocketmqVersion, this.rocketmqVersion), "unzip rocketmq.zip", "rm -f rocketmq.zip", "mv rocketmq-all*/* .", "rmdir rocketmq-all*"});
            log.info("Node {} download rocketmq success", (Object)this.node);
            SshUtil.execCommandInDir((String)this.node, (String)this.installDir, (String[])new String[]{"sed -i 's/-Xms8g -Xmx8g -Xmn4g/-Xmx1500m/g' bin/runbroker.sh"});
            SshUtil.execCommandInDir((String)this.node, (String)this.installDir, (String[])new String[]{"sed -i  's/-Xms4g -Xmx4g -Xmn2g -XX:MetaspaceSize=128m -XX:MaxMetaspaceSize=320m/-Xms500m -Xmx500m -Xmn250m -XX:MetaspaceSize=16m -XX:MaxMetaspaceSize=40m/g' bin/runserver.sh"});
            Field[] fields = this.rmqBrokerConfig.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                String name = fields[i].getName();
                String value = (String)fields[i].get(this.rmqBrokerConfig);
                if (value == null || value.isEmpty()) continue;
                SshUtil.execCommandInDir((String)this.node, (String)this.installDir, (String[])new String[]{String.format("echo '%s' >> %s", name + "=" + value, this.configureFilePath)});
            }
            String dledgerPeers = this.getDledgerPeers(this.nodes);
            SshUtil.execCommandInDir((String)this.node, (String)this.installDir, (String[])new String[]{String.format("echo '%s' >> %s", "dLegerPeers=" + dledgerPeers, this.configureFilePath)});
            SshUtil.execCommandInDir((String)this.node, (String)this.installDir, (String[])new String[]{String.format("echo '%s' >> %s", "dLegerSelfId=n" + this.nodes.indexOf(this.node), this.configureFilePath)});
        }
        catch (Exception e) {
            log.error("Node {} setup rocketmq node failed", (Object)this.node, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public void teardown() {
        try {
            SshUtil.execCommand((String)this.node, (String)String.format("rm -rf %s; mkdir %s", this.installDir, this.installDir));
        }
        catch (Exception e) {
            log.error("Node {} teardown rocketmq node failed", (Object)this.node, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public void start() {
        try {
            if (this.rmqBrokerConfig.namesrvAddr == null || this.rmqBrokerConfig.namesrvAddr.isEmpty()) {
                log.info("Node {} start nameserver...", (Object)this.node);
                SshUtil.execCommandInDir((String)this.node, (String)this.installDir, (String[])new String[]{"nohup sh bin/mqnamesrv > nameserver.log 2>&1 &"});
            }
            log.info("Node {} start broker...", (Object)this.node);
            SshUtil.execCommandInDir((String)this.node, (String)this.installDir, (String[])new String[]{String.format("nohup sh bin/mqbroker -n '%s' -c %s > broker.log 2>&1 &", this.getNameserver(this.nodes), this.configureFilePath)});
        }
        catch (Exception e) {
            log.error("Node {} start rocketmq node failed", (Object)this.node, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            KillProcessUtil.kill((String)this.node, (String)BROKER_PROCESS_NAME);
            if (this.rmqBrokerConfig.namesrvAddr == null || this.rmqBrokerConfig.namesrvAddr.isEmpty()) {
                KillProcessUtil.kill((String)this.node, (String)NAMESERVER_PROCESS_NAME);
            }
        }
        catch (Exception e) {
            log.error("Node {} stop rocketmq processes failed", (Object)this.node, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public void kill() {
        try {
            KillProcessUtil.forceKill((String)this.node, (String)BROKER_PROCESS_NAME);
            if (this.rmqBrokerConfig.namesrvAddr == null || this.rmqBrokerConfig.namesrvAddr.isEmpty()) {
                KillProcessUtil.forceKill((String)this.node, (String)NAMESERVER_PROCESS_NAME);
            }
        }
        catch (Exception e) {
            log.error("Node {} kill rocketmq processes failed", (Object)this.node, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public void pause() {
        try {
            PauseProcessUtil.suspend((String)this.node, (String)BROKER_PROCESS_NAME);
            if (this.rmqBrokerConfig.namesrvAddr == null || this.rmqBrokerConfig.namesrvAddr.isEmpty()) {
                PauseProcessUtil.suspend((String)this.node, (String)NAMESERVER_PROCESS_NAME);
            }
        }
        catch (Exception e) {
            log.error("Node {} pause rocketmq processes failed", (Object)this.node, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public void resume() {
        try {
            PauseProcessUtil.resume((String)this.node, (String)BROKER_PROCESS_NAME);
            if (this.rmqBrokerConfig.namesrvAddr == null || this.rmqBrokerConfig.namesrvAddr.isEmpty()) {
                PauseProcessUtil.resume((String)this.node, (String)NAMESERVER_PROCESS_NAME);
            }
        }
        catch (Exception e) {
            log.error("Node {} resume rocketmq processes failed", (Object)this.node, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private String getDledgerPeers(List<String> nodes) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < nodes.size(); ++i) {
            res.append("n" + i + "-" + nodes.get(i) + ":20911;");
        }
        return res.toString();
    }

    private String getNameserver(List<String> nodes) {
        if (this.rmqBrokerConfig.namesrvAddr != null && !this.rmqBrokerConfig.namesrvAddr.isEmpty()) {
            return this.rmqBrokerConfig.namesrvAddr;
        }
        StringBuilder res = new StringBuilder();
        nodes.forEach(node -> res.append(node + ":9876;"));
        return res.toString();
    }
}

