/*
 * Decompiled with CFR 0.152.
 */
package io.opengemini.client.spring.data.config;

import io.opengemini.client.api.Configuration;
import io.opengemini.client.api.OpenGeminiAsyncClient;
import io.opengemini.client.api.OpenGeminiException;
import io.opengemini.client.impl.OpenGeminiClientFactory;
import io.opengemini.client.spring.data.core.ClientConfigurationBuilderCustomizer;
import io.opengemini.client.spring.data.core.DefaultOpenGeminiSerializerFactory;
import io.opengemini.client.spring.data.core.MeasurementScanConfigurer;
import io.opengemini.client.spring.data.core.MeasurementScanInitializer;
import io.opengemini.client.spring.data.core.OpenGeminiProperties;
import io.opengemini.client.spring.data.core.OpenGeminiPropertiesConverter;
import io.opengemini.client.spring.data.core.OpenGeminiSerializerFactory;
import io.opengemini.client.spring.data.core.OpenGeminiTemplate;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.Nullable;

@AutoConfiguration
@ConditionalOnClass(value={OpenGeminiTemplate.class})
@EnableConfigurationProperties(value={OpenGeminiProperties.class})
public class OpenGeminiAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={OpenGeminiTemplate.class})
    public OpenGeminiTemplate openGeminiTemplate(OpenGeminiAsyncClient openGeminiAsyncClient, OpenGeminiSerializerFactory openGeminiSerializerFactory) {
        return new OpenGeminiTemplate(openGeminiAsyncClient, openGeminiSerializerFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={OpenGeminiAsyncClient.class})
    public OpenGeminiAsyncClient openGeminiAsyncClient(OpenGeminiProperties properties, ObjectProvider<ClientConfigurationBuilderCustomizer> customizers) throws OpenGeminiException {
        OpenGeminiPropertiesConverter converter = new OpenGeminiPropertiesConverter(properties, customizers);
        return OpenGeminiClientFactory.create((Configuration)converter.toConfiguration());
    }

    @Bean
    @ConditionalOnMissingBean(value={OpenGeminiSerializerFactory.class})
    public OpenGeminiSerializerFactory openGeminiSerializerFactory() {
        return new DefaultOpenGeminiSerializerFactory();
    }

    @Bean
    public MeasurementScanInitializer measurementScanInitializer(OpenGeminiTemplate openGeminiTemplate, @Nullable MeasurementScanConfigurer configurer) {
        return new MeasurementScanInitializer(openGeminiTemplate, configurer);
    }
}

