/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.test.stream;

import io.openapiprocessor.test.stream.Memory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.spi.URLStreamHandlerProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/openapiprocessor/test/stream/MemoryStreamHandlerProvider;", "Ljava/net/spi/URLStreamHandlerProvider;", "()V", "createURLStreamHandler", "Ljava/net/URLStreamHandler;", "protocol", "", "openapi-processor-test"})
public final class MemoryStreamHandlerProvider
extends URLStreamHandlerProvider {
    @Override
    @Nullable
    public URLStreamHandler createURLStreamHandler(@Nullable String protocol) {
        if (!Intrinsics.areEqual((Object)"memory", (Object)protocol)) {
            return null;
        }
        return new URLStreamHandler(){

            @NotNull
            protected URLConnection openConnection(@NotNull URL url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                if (!Intrinsics.areEqual((Object)"memory", (Object)url.getProtocol())) {
                    throw new IOException("unknown protocol: " + url.getProtocol());
                }
                return new URLConnection(url){
                    @Nullable
                    private byte[] data;
                    final /* synthetic */ URL $url;
                    {
                        this.$url = $url;
                        super($url);
                    }

                    public void connect() {
                        this.connected = true;
                        String string = this.$url.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        this.data = Memory.Companion.get(string);
                    }

                    public long getContentLengthLong() {
                        if (this.data == null) {
                            return -1L;
                        }
                        Intrinsics.checkNotNull((Object)this.data);
                        return this.data.length;
                    }

                    @NotNull
                    public InputStream getInputStream() {
                        if (!this.connected) {
                            this.connect();
                        }
                        return new ByteArrayInputStream(this.data);
                    }
                };
            }
        };
    }
}

