/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.generator.model;

import io.objectbox.generator.IdUid;
import io.objectbox.generator.TextUtil;
import io.objectbox.generator.model.Entity;
import io.objectbox.generator.model.HasParsedElement;
import io.objectbox.generator.model.Index;
import io.objectbox.generator.model.ModelRuntimeException;
import io.objectbox.generator.model.PropertyType;
import io.objectbox.generator.model.Schema;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class Property
implements HasParsedElement {
    private final Schema schema;
    private final Entity entity;
    private Entity targetEntity;
    private PropertyType propertyType;
    private final String propertyName;
    private IdUid modelId;
    private IdUid modelIndexId;
    private String dbName;
    private String dbType;
    private Short dbTypeId;
    private String customType;
    private String customTypeClassName;
    private String converter;
    private String converterClassName;
    private boolean primaryKey;
    private boolean idCompanion;
    private boolean isTypeNotNull;
    private boolean isNotNullFlag;
    private boolean isNonPrimitiveFlag;
    private boolean isUnsigned;
    private boolean idAssignable;
    private boolean fieldAccessible;
    private int ordinal;
    private String javaType;
    @Nullable
    private String javaRawType;
    private String virtualTargetName;
    private String virtualTargetValueExpression;
    private String getterMethodName;
    private Object parsedElement;
    private Integer propertyFlagsModelFile;
    private Set<String> propertyFlagsGeneratedCode;
    private Index index;

    public Property(Schema schema, Entity entity, PropertyType propertyType, String propertyName) {
        this.schema = schema;
        this.entity = entity;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    public IdUid getModelId() {
        return this.modelId;
    }

    public void setModelId(IdUid modelId) {
        this.modelId = modelId;
    }

    public IdUid getModelIndexId() {
        return this.modelIndexId;
    }

    public void setModelIndexId(IdUid modelIndexId) {
        this.modelIndexId = modelIndexId;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getDbType() {
        return this.dbType;
    }

    public Short getDbTypeId() {
        return this.dbTypeId;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isIdCompanion() {
        return this.idCompanion;
    }

    public boolean isTypeNotNull() {
        return this.isTypeNotNull;
    }

    public boolean isNotNullFlag() {
        return this.isNotNullFlag;
    }

    public boolean isNonPrimitiveFlag() {
        return this.isNonPrimitiveFlag;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public boolean isIdAssignable() {
        return this.idAssignable;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public String getJavaRawType() {
        return this.javaRawType != null ? this.javaRawType : this.javaType;
    }

    public String getJavaTypeInEntity() {
        if (this.customTypeClassName != null) {
            return this.customTypeClassName;
        }
        return this.javaType;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public String getCustomType() {
        return this.customType;
    }

    public String getCustomTypeClassName() {
        return this.customTypeClassName;
    }

    public String getConverter() {
        return this.converter;
    }

    public String getConverterClassName() {
        return this.converterClassName;
    }

    public boolean isVirtual() {
        return this.virtualTargetName != null;
    }

    public String getVirtualTargetValueExpression() {
        return this.virtualTargetValueExpression;
    }

    public String getVirtualTargetName() {
        return this.virtualTargetName;
    }

    public String getGetterMethodName() {
        return this.getterMethodName;
    }

    void convertToRelationId(Entity target) {
        if (this.propertyType != PropertyType.Long && this.propertyType != PropertyType.RelationId) {
            throw new ModelRuntimeException("Relation ID property must be of type long: " + this);
        }
        this.propertyType = PropertyType.RelationId;
        this.targetEntity = target;
        if (this.index == null) {
            this.index = new Index(this);
            this.entity.addIndex(this.index);
        }
    }

    public Entity getTargetEntity() {
        return this.targetEntity;
    }

    public String getValueExpression() {
        if (this.fieldAccessible) {
            return this.propertyName;
        }
        if (this.getterMethodName != null && this.getterMethodName.length() > 0) {
            return this.getterMethodName + "()";
        }
        return "get" + TextUtil.capFirst(this.propertyName) + "()";
    }

    public String getSetValueExpression(String value) {
        if (this.fieldAccessible) {
            return this.propertyName + " = " + value;
        }
        return "set" + TextUtil.capFirst(this.propertyName) + "(" + value + ")";
    }

    public String getDatabaseValueExpression() {
        return this.getDatabaseValueExpression(this.getValueExpression());
    }

    public String getDatabaseValueExpression(String entityValue) {
        StringBuilder builder = new StringBuilder();
        if (this.customType != null) {
            builder.append(this.propertyName).append("Converter.convertToDatabaseValue(");
        }
        builder.append(entityValue);
        if (this.customType != null) {
            builder.append(')');
        }
        if (this.propertyType == PropertyType.Boolean) {
            builder.append(" ? 1 : 0");
        } else if (this.propertyType == PropertyType.Date) {
            builder.append(".getTime()");
        }
        return builder.toString();
    }

    public Entity getEntity() {
        return this.entity;
    }

    @Nullable
    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    void init2ndPass() {
        if (this.idAssignable && !this.primaryKey) {
            throw new ModelRuntimeException("idSelfAssignable set for non-ID property");
        }
        if (this.dbType == null) {
            this.dbType = this.schema.mapToDbType(this.propertyType);
            this.dbTypeId = this.schema.mapToDbTypeId(this.propertyType);
        }
        if (this.dbName == null) {
            this.dbName = TextUtil.dbName(this.propertyName);
        }
        this.javaType = this.isTypeNotNull() || this.customType != null || this.propertyType == PropertyType.StringArray && !this.isNonPrimitiveFlag() ? this.schema.mapToJavaTypeNotNull(this.propertyType) : this.schema.mapToJavaTypeNullable(this.propertyType);
        int typeArgumentsOpen = this.javaType.indexOf("<");
        if (typeArgumentsOpen != -1) {
            this.javaRawType = this.javaType.substring(0, typeArgumentsOpen);
        }
    }

    void init3ndPass() {
    }

    @Override
    public Object getParsedElement() {
        return this.parsedElement;
    }

    @Override
    public void setParsedElement(Object parsedElement) {
        this.parsedElement = parsedElement;
    }

    public void computePropertyFlags() {
        int flagsModelFile = 0;
        LinkedHashSet<String> flagsGeneratedCode = new LinkedHashSet<String>();
        if (this.isPrimaryKey()) {
            flagsModelFile |= 1;
            flagsGeneratedCode.add("PropertyFlags.ID");
        }
        if (this.isIdAssignable()) {
            flagsModelFile |= 0x80;
            flagsGeneratedCode.add("PropertyFlags.ID_SELF_ASSIGNABLE");
        }
        if (this.isIdCompanion()) {
            flagsModelFile |= 0x4000;
            flagsGeneratedCode.add("PropertyFlags.ID_COMPANION");
        }
        if (this.isNotNullFlag() && !this.isPrimaryKey()) {
            flagsModelFile |= 4;
            flagsGeneratedCode.add("PropertyFlags.NOT_NULL");
        }
        if (this.isNonPrimitiveFlag()) {
            flagsGeneratedCode.add("PropertyFlags.NON_PRIMITIVE_TYPE");
        }
        if (this.isVirtual()) {
            flagsGeneratedCode.add("PropertyFlags.VIRTUAL");
        }
        if (this.isUnsigned()) {
            flagsModelFile |= 0x2000;
            flagsGeneratedCode.add("PropertyFlags.UNSIGNED");
        }
        if (this.getPropertyType() == PropertyType.RelationId) {
            flagsModelFile |= 8;
            flagsGeneratedCode.add("PropertyFlags.INDEXED");
            flagsModelFile |= 0x200;
            flagsGeneratedCode.add("PropertyFlags.INDEX_PARTIAL_SKIP_ZERO");
        } else if (this.getIndex() != null) {
            flagsModelFile |= this.getIndex().getIndexFlags();
            flagsGeneratedCode.addAll(this.getIndex().getIndexFlagsAsNames());
        }
        this.propertyFlagsModelFile = flagsModelFile;
        this.propertyFlagsGeneratedCode = flagsGeneratedCode;
    }

    @Nullable
    public Integer getPropertyFlagsForModelFile() {
        if (this.propertyFlagsModelFile == null) {
            this.computePropertyFlags();
        }
        return this.propertyFlagsModelFile != 0 ? this.propertyFlagsModelFile : null;
    }

    public Set<String> getPropertyFlagsForGeneratedCode() {
        if (this.propertyFlagsGeneratedCode == null) {
            this.computePropertyFlags();
        }
        return this.propertyFlagsGeneratedCode;
    }

    public String toString() {
        return "Property " + this.propertyName + " of " + this.entity.getClassName();
    }

    public static class PropertyBuilder {
        private final Property property;

        public PropertyBuilder(Schema schema, Entity entity, PropertyType propertyType, String propertyName) {
            this.property = new Property(schema, entity, propertyType, propertyName);
        }

        public PropertyBuilder dbName(String dbName) {
            this.property.dbName = dbName;
            return this;
        }

        public PropertyBuilder dbType(String dbType) {
            this.property.dbType = dbType;
            return this;
        }

        public PropertyBuilder modelId(IdUid modelId) {
            this.property.modelId = modelId;
            return this;
        }

        public PropertyBuilder modelIndexId(IdUid indexId) {
            this.property.modelIndexId = indexId;
            return this;
        }

        public PropertyBuilder primaryKey() {
            this.property.primaryKey = true;
            return this;
        }

        public PropertyBuilder idCompanion() {
            if (this.property.propertyType != PropertyType.Date && this.property.propertyType != PropertyType.DateNano) {
                throw new RuntimeException("Only Date or DateNano properties can be an ID companion.");
            }
            this.property.idCompanion = true;
            return this;
        }

        public PropertyBuilder typeNotNull() {
            this.property.isTypeNotNull = true;
            return this;
        }

        public PropertyBuilder notNullFlag() {
            this.property.isNotNullFlag = true;
            return this;
        }

        public PropertyBuilder idAssignable() {
            this.property.idAssignable = true;
            return this;
        }

        public PropertyBuilder fieldAccessible() {
            this.property.fieldAccessible = true;
            return this;
        }

        public PropertyBuilder nonPrimitiveFlag() {
            if (!this.property.propertyType.isScalar() && this.property.customType == null && this.property.propertyType != PropertyType.StringArray) {
                throw new ModelRuntimeException("Type is already non-primitive");
            }
            this.property.isNonPrimitiveFlag = true;
            return this;
        }

        public PropertyBuilder unsigned() {
            PropertyType type = this.property.propertyType;
            if (this.property.primaryKey || type != PropertyType.Byte && type != PropertyType.Short && type != PropertyType.Int && type != PropertyType.Long && type != PropertyType.Char) {
                throw new RuntimeException("Only non-primary key and integer properties can be marked unsigned.");
            }
            this.property.isUnsigned = true;
            return this;
        }

        public PropertyBuilder index() {
            return this.index(8, 0);
        }

        public PropertyBuilder index(int indexFlags, int maxValueLength) {
            Index index = new Index(this.property, indexFlags);
            index.setMaxValueLength(maxValueLength);
            this.property.entity.addIndex(index);
            return this;
        }

        public PropertyBuilder customType(String customType, String converter) {
            this.property.customType = customType;
            this.property.customTypeClassName = TextUtil.getClassnameFromFullyQualified(customType);
            this.property.converter = converter;
            this.property.converterClassName = TextUtil.getClassnameFromFullyQualified(converter);
            return this;
        }

        public PropertyBuilder virtualTargetName(String virtualTargetName) {
            this.property.virtualTargetName = virtualTargetName;
            return this;
        }

        public PropertyBuilder virtualTargetValueExpression(String virtualTargetValueExpression) {
            this.property.virtualTargetValueExpression = virtualTargetValueExpression;
            return this;
        }

        public PropertyBuilder getterMethodName(String getterMethodName) {
            this.property.getterMethodName = getterMethodName;
            return this;
        }

        public Property getProperty() {
            return this.property;
        }
    }
}

