/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.generator.model;

import io.objectbox.generator.IdUid;
import io.objectbox.generator.TextUtil;
import io.objectbox.generator.model.HasParsedElement;
import io.objectbox.generator.model.Index;
import io.objectbox.generator.model.ModelException;
import io.objectbox.generator.model.Property;
import io.objectbox.generator.model.PropertyType;
import io.objectbox.generator.model.Schema;
import io.objectbox.generator.model.ToManyBase;
import io.objectbox.generator.model.ToManyByBacklink;
import io.objectbox.generator.model.ToManyStandalone;
import io.objectbox.generator.model.ToOne;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

public class Entity
implements HasParsedElement {
    private final Schema schema;
    private final String className;
    private Integer modelId;
    private Long modelUid;
    private IdUid lastPropertyId;
    private final List<Property> properties;
    private List<Property> propertiesColumns;
    private final List<Property> propertiesPk;
    private final Map<String, Object> names;
    private final List<Index> indexes;
    private final List<Index> multiIndexes;
    private final List<ToOne> toOneRelations;
    private final List<ToManyBase> toManyRelations;
    private final List<ToManyBase> incomingToManyRelations;
    private final Collection<String> additionalImportsDao;
    private String dbName;
    private String classNameDao;
    private String javaPackage;
    private String javaPackageDao;
    private Property pkProperty;
    private String pkType;
    private boolean hasAllArgsConstructor;
    private boolean hasBoxStoreField;
    private Object parsedElement;
    private boolean syncEnabled;
    private boolean syncSharedGlobalIds;
    private Integer entityFlags;
    private Integer entityFlagsModelFile;
    private Set<String> entityFlagsNames;

    Entity(Schema schema, String className) {
        this.schema = schema;
        this.className = className;
        this.properties = new ArrayList<Property>();
        this.propertiesPk = new ArrayList<Property>();
        this.names = new HashMap<String, Object>();
        this.indexes = new ArrayList<Index>();
        this.multiIndexes = new ArrayList<Index>();
        this.toOneRelations = new ArrayList<ToOne>();
        this.toManyRelations = new ArrayList<ToManyBase>();
        this.incomingToManyRelations = new ArrayList<ToManyBase>();
        this.additionalImportsDao = new TreeSet<String>();
        this.hasAllArgsConstructor = false;
    }

    public Entity setModelId(Integer modelId) {
        this.modelId = modelId;
        return this;
    }

    public Integer getModelId() {
        return this.modelId;
    }

    public Entity setModelUid(Long modelUid) {
        this.modelUid = modelUid;
        return this;
    }

    public Long getModelUid() {
        return this.modelUid;
    }

    public IdUid getLastPropertyId() {
        return this.lastPropertyId;
    }

    public Entity setLastPropertyId(IdUid lastPropertyId) {
        this.lastPropertyId = lastPropertyId;
        return this;
    }

    public Property.PropertyBuilder addProperty(PropertyType propertyType, String propertyName) throws ModelException {
        Property.PropertyBuilder builder = new Property.PropertyBuilder(this.schema, this, propertyType, propertyName);
        Property property = builder.getProperty();
        this.trackUniqueName(this.names, propertyName, property);
        this.properties.add(property);
        return builder;
    }

    public Property.PropertyBuilder addIdProperty() throws ModelException {
        return this.addProperty(PropertyType.Long, "id").primaryKey();
    }

    public ToManyByBacklink addToManyByToOneBacklink(ToManyByBacklink toMany, Entity targetEntity, ToOne targetToOne) throws ModelException {
        toMany.setSourceAndTargetEntity(this, targetEntity);
        toMany.setTargetToOne(targetToOne);
        this.trackNameAndaddToMany(toMany);
        return toMany;
    }

    public ToManyByBacklink addToManyByToManyBacklink(ToManyByBacklink toMany, Entity targetEntity, ToManyStandalone targetToMany) throws ModelException {
        toMany.setSourceAndTargetEntity(this, targetEntity);
        toMany.setTargetToMany(targetToMany);
        this.trackNameAndaddToMany(toMany);
        return toMany;
    }

    public ToManyStandalone addToMany(ToManyStandalone toMany, Entity target) throws ModelException {
        toMany.setSourceAndTargetEntity(this, target);
        this.trackNameAndaddToMany(toMany);
        return toMany;
    }

    private void trackNameAndaddToMany(ToManyBase toMany) throws ModelException {
        this.trackUniqueName(this.names, toMany.getName(), toMany);
        this.toManyRelations.add(toMany);
        toMany.getTargetEntity().getIncomingToManyRelations().add(toMany);
    }

    public ToOne addToOne(ToOne toOne, Entity target) throws ModelException {
        toOne.setSourceAndTargetEntity(this, target);
        this.toOneRelations.add(toOne);
        this.trackUniqueName(this.names, toOne.getName(), toOne);
        return toOne;
    }

    public Entity addIndex(Index index) {
        this.indexes.add(index);
        return this;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getClassName() {
        return this.className;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Property findPropertyByName(String name) {
        for (Property property : this.properties) {
            if (!name.equals(property.getPropertyName())) continue;
            return property;
        }
        return null;
    }

    public List<Property> getPropertiesColumns() {
        return this.propertiesColumns;
    }

    public String getJavaPackage() {
        return this.javaPackage;
    }

    public void setJavaPackage(String javaPackage) {
        this.javaPackage = javaPackage;
    }

    public String getJavaPackageDao() {
        return this.javaPackageDao;
    }

    public void setJavaPackageDao(String javaPackageDao) {
        this.javaPackageDao = javaPackageDao;
    }

    public String getClassNameDao() {
        return this.classNameDao;
    }

    public void setClassNameDao(String classNameDao) {
        this.classNameDao = classNameDao;
    }

    public List<Property> getPropertiesPk() {
        return this.propertiesPk;
    }

    public Property getPkProperty() {
        return this.pkProperty;
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    public String getPkType() {
        return this.pkType;
    }

    public boolean hasAllArgsConstructor() {
        return this.hasAllArgsConstructor;
    }

    public void setHasAllArgsConstructor(boolean hasAllArgsConstructor) {
        this.hasAllArgsConstructor = hasAllArgsConstructor;
    }

    public boolean hasRelations() {
        return !this.toOneRelations.isEmpty() || !this.toManyRelations.isEmpty();
    }

    public List<ToOne> getToOneRelations() {
        return this.toOneRelations;
    }

    public List<ToManyBase> getToManyRelations() {
        return this.toManyRelations;
    }

    public List<ToManyBase> getIncomingToManyRelations() {
        return this.incomingToManyRelations;
    }

    public Collection<String> getAdditionalImportsDao() {
        return this.additionalImportsDao;
    }

    public boolean getHasBoxStoreField() {
        return this.hasBoxStoreField;
    }

    public void setHasBoxStoreField(boolean hasBoxStoreField) {
        this.hasBoxStoreField = hasBoxStoreField;
    }

    void init2ndPass() {
        this.init2ndPassNamesWithDefaults();
        for (int i = 0; i < this.properties.size(); ++i) {
            Property property = this.properties.get(i);
            property.setOrdinal(i);
            property.init2ndPass();
            if (!property.isPrimaryKey()) continue;
            this.propertiesPk.add(property);
        }
        for (Index index : this.indexes) {
            int propertiesSize = index.getProperties().size();
            if (propertiesSize == 1) {
                Property property = index.getProperties().get(0);
                property.setIndex(index);
                continue;
            }
            if (propertiesSize <= 1) continue;
            this.multiIndexes.add(index);
        }
        if (this.propertiesPk.size() == 1) {
            this.pkProperty = this.propertiesPk.get(0);
            this.pkType = this.schema.mapToJavaTypeNullable(this.pkProperty.getPropertyType());
        } else {
            this.pkType = "Void";
        }
        this.propertiesColumns = new ArrayList<Property>(this.properties);
        for (ToOne toOne : this.toOneRelations) {
            Property targetIdProperty = toOne.getIdRefProperty();
            if (this.propertiesColumns.contains(targetIdProperty)) continue;
            this.propertiesColumns.add(targetIdProperty);
        }
    }

    protected void init2ndPassNamesWithDefaults() {
        if (this.dbName == null) {
            this.dbName = TextUtil.dbName(this.className);
        }
        if (this.classNameDao == null) {
            this.classNameDao = this.className + "Dao";
        }
        if (this.javaPackage == null) {
            this.javaPackage = this.schema.getDefaultJavaPackage();
        }
        if (this.javaPackageDao == null) {
            this.javaPackageDao = this.schema.getDefaultJavaPackageDao();
            if (this.javaPackageDao == null) {
                this.javaPackageDao = this.javaPackage;
            }
        }
    }

    void init3rdPass() throws ModelException {
        for (Property property : this.properties) {
            property.init3ndPass();
        }
        this.init3rdPassRelations();
        this.init3rdPassAdditionalImports();
        this.verifyAllNamesUnique();
    }

    private void verifyAllNamesUnique() throws ModelException {
        HashMap<String, Object> names = new HashMap<String, Object>();
        for (Property property : this.properties) {
            this.trackUniqueName(names, property.getPropertyName(), property);
        }
        for (ToOne toOne : this.toOneRelations) {
            this.trackUniqueName(names, toOne.getName(), toOne);
        }
        for (ToManyBase toMany : this.toManyRelations) {
            this.trackUniqueName(names, toMany.getName(), toMany);
        }
    }

    private void trackUniqueName(Map<String, Object> names, String name, Object object) throws ModelException {
        Object oldValue = names.put(name.toLowerCase(), object);
        if (oldValue != null) {
            throw new ModelException("Duplicate name \"" + name + "\" in entity \"" + this.className + "\": [" + object + "] vs. [" + oldValue + "]");
        }
    }

    private void init3rdPassRelations() {
        for (ToOne toOne : this.toOneRelations) {
            toOne.init3ndPass();
        }
        for (ToManyBase toMany : this.toManyRelations) {
            toMany.init3rdPass();
        }
    }

    private void init3rdPassAdditionalImports() {
        Entity targetEntity;
        for (ToOne toOne : this.toOneRelations) {
            targetEntity = toOne.getTargetEntity();
            this.checkAdditionalImportsDaoTargetEntity(targetEntity);
        }
        for (ToManyBase toMany : this.toManyRelations) {
            targetEntity = toMany.getTargetEntity();
            this.checkAdditionalImportsDaoTargetEntity(targetEntity);
        }
        for (Property property : this.properties) {
            String pack;
            String converter;
            String pack2;
            String customType = property.getCustomType();
            if (customType != null && (pack2 = TextUtil.getPackageFromFullyQualified(customType)) != null && !pack2.equals(this.javaPackageDao)) {
                this.additionalImportsDao.add(customType);
            }
            if ((converter = property.getConverter()) == null || (pack = TextUtil.getPackageFromFullyQualified(converter)) == null || pack.equals(this.javaPackageDao)) continue;
            this.additionalImportsDao.add(converter);
        }
    }

    private void checkAdditionalImportsDaoTargetEntity(Entity targetEntity) {
        if (!targetEntity.getJavaPackage().equals(this.javaPackageDao)) {
            this.additionalImportsDao.add(targetEntity.getJavaPackage() + "." + targetEntity.getClassName());
        }
    }

    public List<Index> getMultiIndexes() {
        return this.multiIndexes;
    }

    @Override
    public Object getParsedElement() {
        return this.parsedElement;
    }

    @Override
    public void setParsedElement(Object parsedElement) {
        this.parsedElement = parsedElement;
    }

    public boolean isSyncEnabled() {
        return this.syncEnabled;
    }

    public void setSyncEnabled(boolean syncEnabled) {
        this.syncEnabled = syncEnabled;
    }

    public boolean isSyncSharedGlobalIds() {
        return this.syncSharedGlobalIds;
    }

    public void setSyncSharedGlobalIds(boolean enabled) {
        this.syncSharedGlobalIds = enabled;
    }

    public void computeEntityFlags() {
        int flags = 0;
        int flagsModelFile = 0;
        LinkedHashSet<String> flagsNames = new LinkedHashSet<String>();
        if (!this.hasAllArgsConstructor()) {
            flags |= 1;
            flagsNames.add("io.objectbox.model.EntityFlags.USE_NO_ARG_CONSTRUCTOR");
        }
        if (this.isSyncEnabled()) {
            flags |= 2;
            flagsModelFile |= 2;
            flagsNames.add("io.objectbox.model.EntityFlags.SYNC_ENABLED");
        }
        if (this.isSyncSharedGlobalIds()) {
            flags |= 4;
            flagsModelFile |= 4;
            flagsNames.add("io.objectbox.model.EntityFlags.SHARED_GLOBAL_IDS");
        }
        this.entityFlags = flags;
        this.entityFlagsModelFile = flagsModelFile;
        this.entityFlagsNames = flagsNames;
    }

    public int getEntityFlags() {
        if (this.entityFlags == null) {
            this.computeEntityFlags();
        }
        return this.entityFlags;
    }

    @Nullable
    public Integer getEntityFlagsForModelFile() {
        if (this.entityFlagsModelFile == null) {
            this.computeEntityFlags();
        }
        return this.entityFlagsModelFile != 0 ? this.entityFlagsModelFile : null;
    }

    public Set<String> getEntityFlagsNames() {
        if (this.entityFlagsNames == null) {
            this.computeEntityFlags();
        }
        return this.entityFlagsNames;
    }

    public String toString() {
        return "Entity " + this.className + " (package: " + this.javaPackage + ")";
    }
}

