/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.reporting;

import com.squareup.moshi.JsonClass;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import io.objectbox.reporting.ObjectBoxBuildConfigJsonAdapter;
import java.io.Closeable;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonClass(generateAdapter=true)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lio/objectbox/reporting/ObjectBoxBuildConfig;", "", "projectDir", "", "flavor", "(Ljava/lang/String;Ljava/lang/String;)V", "getFlavor", "()Ljava/lang/String;", "getProjectDir", "timeStarted", "", "getTimeStarted", "()J", "writeInto", "", "buildConfigFile", "Ljava/io/File;", "Companion", "objectbox-code-modifier"})
public final class ObjectBoxBuildConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String projectDir;
    @Nullable
    private final String flavor;
    private final long timeStarted;
    @NotNull
    public static final String FILE_NAME = "objectbox-build-config.json";

    public ObjectBoxBuildConfig(@NotNull String projectDir, @Nullable String flavor) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        this.projectDir = projectDir;
        this.flavor = flavor;
        this.timeStarted = System.currentTimeMillis();
    }

    public /* synthetic */ ObjectBoxBuildConfig(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @NotNull
    public final String getProjectDir() {
        return this.projectDir;
    }

    @Nullable
    public final String getFlavor() {
        return this.flavor;
    }

    public final long getTimeStarted() {
        return this.timeStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeInto(@NotNull File buildConfigFile) {
        Intrinsics.checkNotNullParameter((Object)buildConfigFile, (String)"buildConfigFile");
        Moshi moshi = new Moshi.Builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)moshi, (String)"Builder().build()");
        ObjectBoxBuildConfigJsonAdapter adapter = new ObjectBoxBuildConfigJsonAdapter(moshi);
        Buffer buffer = new Buffer();
        JsonWriter jsonWriter = JsonWriter.of((BufferedSink)((BufferedSink)buffer));
        jsonWriter.setIndent("  ");
        Intrinsics.checkNotNullExpressionValue((Object)jsonWriter, (String)"jsonWriter");
        adapter.toJson(jsonWriter, this);
        Closeable closeable = (Closeable)Okio.sink$default((File)buildConfigFile, (boolean)false, (int)1, null);
        Throwable throwable = null;
        try {
            Sink it = (Sink)closeable;
            boolean bl = false;
            long l = buffer.readAll(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/objectbox/reporting/ObjectBoxBuildConfig$Companion;", "", "()V", "FILE_NAME", "", "buildFile", "Ljava/io/File;", "outputDir", "objectbox-code-modifier"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File buildFile(@NotNull File outputDir) {
            Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            return new File(outputDir, ObjectBoxBuildConfig.FILE_NAME);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

