/*
 * Decompiled with CFR 0.152.
 */
package io.nixer.fork.com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hashing;
import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import io.nixer.bloom.BitArray;
import io.nixer.fork.com.google.common.hash.GuavaBloomFilter;
import java.math.RoundingMode;

public enum GuavaBloomFilterStrategies implements GuavaBloomFilter.Strategy
{
    MURMUR128_MITZ_32{

        @Override
        public <T> boolean put(T object, Funnel<? super T> funnel, int numHashFunctions, BitArray bits) {
            long bitSize = bits.bitSize();
            long hash64 = Hashing.murmur3_128().hashObject(object, funnel).asLong();
            int hash1 = (int)hash64;
            int hash2 = (int)(hash64 >>> 32);
            boolean bitsChanged = false;
            for (int i = 1; i <= numHashFunctions; ++i) {
                int combinedHash = hash1 + i * hash2;
                if (combinedHash < 0) {
                    combinedHash ^= 0xFFFFFFFF;
                }
                bitsChanged |= bits.set((long)combinedHash % bitSize);
            }
            return bitsChanged;
        }

        @Override
        public <T> boolean mightContain(T object, Funnel<? super T> funnel, int numHashFunctions, BitArray bits) {
            long bitSize = bits.bitSize();
            long hash64 = Hashing.murmur3_128().hashObject(object, funnel).asLong();
            int hash1 = (int)hash64;
            int hash2 = (int)(hash64 >>> 32);
            for (int i = 1; i <= numHashFunctions; ++i) {
                int combinedHash = hash1 + i * hash2;
                if (combinedHash < 0) {
                    combinedHash ^= 0xFFFFFFFF;
                }
                if (bits.get((long)combinedHash % bitSize)) continue;
                return false;
            }
            return true;
        }
    }
    ,
    MURMUR128_MITZ_64{

        @Override
        public <T> boolean put(T object, Funnel<? super T> funnel, int numHashFunctions, BitArray bits) {
            long bitSize = bits.bitSize();
            byte[] bytes = Hashing.murmur3_128().hashObject(object, funnel).asBytes();
            long hash1 = this.lowerEight(bytes);
            long hash2 = this.upperEight(bytes);
            boolean bitsChanged = false;
            long combinedHash = hash1;
            for (int i = 0; i < numHashFunctions; ++i) {
                bitsChanged |= bits.set((combinedHash & Long.MAX_VALUE) % bitSize);
                combinedHash += hash2;
            }
            return bitsChanged;
        }

        @Override
        public <T> boolean mightContain(T object, Funnel<? super T> funnel, int numHashFunctions, BitArray bits) {
            long bitSize = bits.bitSize();
            byte[] bytes = Hashing.murmur3_128().hashObject(object, funnel).asBytes();
            long hash1 = this.lowerEight(bytes);
            long hash2 = this.upperEight(bytes);
            long combinedHash = hash1;
            for (int i = 0; i < numHashFunctions; ++i) {
                if (!bits.get((combinedHash & Long.MAX_VALUE) % bitSize)) {
                    return false;
                }
                combinedHash += hash2;
            }
            return true;
        }

        private long lowerEight(byte[] bytes) {
            return Longs.fromBytes((byte)bytes[7], (byte)bytes[6], (byte)bytes[5], (byte)bytes[4], (byte)bytes[3], (byte)bytes[2], (byte)bytes[1], (byte)bytes[0]);
        }

        private long upperEight(byte[] bytes) {
            return Longs.fromBytes((byte)bytes[15], (byte)bytes[14], (byte)bytes[13], (byte)bytes[12], (byte)bytes[11], (byte)bytes[10], (byte)bytes[9], (byte)bytes[8]);
        }
    };


    public static final class BitArrayInMemory
    implements BitArray {
        final long[] data;
        long bitCount;

        public BitArrayInMemory(long bits) {
            this(new long[Ints.checkedCast((long)LongMath.divide((long)bits, (long)64L, (RoundingMode)RoundingMode.CEILING))]);
        }

        BitArrayInMemory(long[] data) {
            Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"data length is zero!");
            this.data = data;
            long bitCount = 0L;
            for (long value : data) {
                bitCount += (long)Long.bitCount(value);
            }
            this.bitCount = bitCount;
        }

        @Override
        public boolean set(long index) {
            if (!this.get(index)) {
                int n = (int)(index >>> 6);
                this.data[n] = this.data[n] | 1L << (int)index;
                ++this.bitCount;
                return true;
            }
            return false;
        }

        @Override
        public boolean get(long index) {
            return (this.data[(int)(index >>> 6)] & 1L << (int)index) != 0L;
        }

        @Override
        public long bitSize() {
            return (long)this.data.length * 64L;
        }

        @Override
        public long bitCount() {
            return this.bitCount;
        }
    }
}

