/*
 * Decompiled with CFR 0.152.
 */
package io.nixer.fork.com.google.common.hash;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.Funnel;
import com.google.common.math.DoubleMath;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.nixer.bloom.BitArray;
import io.nixer.bloom.BloomFilter;
import io.nixer.bloom.BloomFilterParameters;
import io.nixer.fork.com.google.common.hash.GuavaBloomFilterStrategies;
import java.io.Serializable;
import java.math.RoundingMode;
import java.nio.ByteOrder;
import javax.annotation.Nonnull;

public final class GuavaBloomFilter<T>
implements BloomFilter<T> {
    private final BitArray bits;
    private final int numHashFunctions;
    private final Funnel<? super T> funnel;
    private final Strategy strategy;
    private final BloomFilterParameters parameters;

    GuavaBloomFilter(BitArray bits, int numHashFunctions, Funnel<? super T> funnel, Strategy strategy, @Nonnull BloomFilterParameters parameters) {
        Preconditions.checkArgument((numHashFunctions > 0 ? 1 : 0) != 0, (String)"numHashFunctions (%s) must be > 0", (int)numHashFunctions);
        Preconditions.checkArgument((numHashFunctions <= 255 ? 1 : 0) != 0, (String)"numHashFunctions (%s) must be <= 255", (int)numHashFunctions);
        this.bits = (BitArray)Preconditions.checkNotNull((Object)bits);
        this.numHashFunctions = numHashFunctions;
        this.funnel = (Funnel)Preconditions.checkNotNull(funnel);
        this.strategy = (Strategy)Preconditions.checkNotNull((Object)strategy);
        this.parameters = parameters;
    }

    @Override
    public boolean mightContain(T object) {
        return this.strategy.mightContain(object, this.funnel, this.numHashFunctions, this.bits);
    }

    @Deprecated
    public boolean apply(T input) {
        return this.mightContain(input);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean put(T object) {
        return this.strategy.put(object, this.funnel, this.numHashFunctions, this.bits);
    }

    @Override
    public double expectedFpp() {
        return Math.pow((double)this.bits.bitCount() / (double)this.bitSize(), this.numHashFunctions);
    }

    @Override
    public long approximateElementCount() {
        long bitSize = this.bits.bitSize();
        long bitCount = this.bits.bitCount();
        double fractionOfBitsSet = (double)bitCount / (double)bitSize;
        return DoubleMath.roundToLong((double)(-Math.log1p(-fractionOfBitsSet) * (double)bitSize / (double)this.numHashFunctions), (RoundingMode)RoundingMode.HALF_UP);
    }

    @Override
    @Nonnull
    public BloomFilterParameters getParameters() {
        return this.parameters;
    }

    @VisibleForTesting
    long bitSize() {
        return this.bits.bitSize();
    }

    public boolean isCompatible(GuavaBloomFilter<T> that) {
        Preconditions.checkNotNull(that);
        return this != that && this.numHashFunctions == that.numHashFunctions && this.bitSize() == that.bitSize() && this.strategy.equals(that.strategy) && this.funnel.equals(that.funnel);
    }

    public static <T> GuavaBloomFilter<T> create(Funnel<? super T> funnel, long expectedInsertions, double fpp, BitArray.Factory bitArrayFactory) {
        return GuavaBloomFilter.create(funnel, expectedInsertions, fpp, GuavaBloomFilterStrategies.MURMUR128_MITZ_64, bitArrayFactory);
    }

    public static <T> GuavaBloomFilter<T> create(Funnel<? super T> funnel, BitArray.Factory bitArrayFactory, BloomFilterParameters parameters) {
        try {
            return new GuavaBloomFilter<T>(bitArrayFactory.create(parameters.getBitSize()), parameters.getNumHashFunctions(), funnel, parameters.getStrategy(), parameters);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not create GuavaBloomFilter of " + parameters.getNumHashFunctions() + " bits", e);
        }
    }

    @VisibleForTesting
    static <T> GuavaBloomFilter<T> create(Funnel<? super T> funnel, long expectedInsertions, double fpp, GuavaBloomFilterStrategies strategy, BitArray.Factory bitArrayFactory) {
        Preconditions.checkNotNull(funnel);
        Preconditions.checkArgument((expectedInsertions >= 0L ? 1 : 0) != 0, (String)"Expected insertions (%s) must be >= 0", (long)expectedInsertions);
        Preconditions.checkArgument((fpp > 0.0 ? 1 : 0) != 0, (String)"False positive probability (%s) must be > 0.0", (Object)fpp);
        Preconditions.checkArgument((fpp < 1.0 ? 1 : 0) != 0, (String)"False positive probability (%s) must be < 1.0", (Object)fpp);
        Preconditions.checkNotNull((Object)strategy);
        if (expectedInsertions == 0L) {
            expectedInsertions = 1L;
        }
        long numBits = GuavaBloomFilter.optimalNumOfBits(expectedInsertions, fpp);
        int numHashFunctions = GuavaBloomFilter.optimalNumOfHashFunctions(expectedInsertions, numBits);
        BloomFilterParameters targetParameters = new BloomFilterParameters(expectedInsertions, fpp, numHashFunctions, numBits, strategy, ByteOrder.nativeOrder());
        try {
            return new GuavaBloomFilter<T>(bitArrayFactory.create(numBits), numHashFunctions, funnel, strategy, targetParameters);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not create GuavaBloomFilter of " + numBits + " bits", e);
        }
    }

    @VisibleForTesting
    static int optimalNumOfHashFunctions(long n, long m) {
        return Math.max(1, (int)Math.round((double)m / (double)n * Math.log(2.0)));
    }

    @VisibleForTesting
    static long optimalNumOfBits(long n, double p) {
        if (p == 0.0) {
            p = Double.MIN_VALUE;
        }
        return (long)((double)(-n) * Math.log(p) / (Math.log(2.0) * Math.log(2.0)));
    }

    public static interface Strategy
    extends Serializable {
        public <T> boolean put(T var1, Funnel<? super T> var2, int var3, BitArray var4);

        public <T> boolean mightContain(T var1, Funnel<? super T> var2, int var3, BitArray var4);

        public int ordinal();
    }
}

