/*
 * Decompiled with CFR 0.152.
 */
package io.nixer.bloom.check;

import com.google.common.base.Strings;
import com.google.common.hash.HashCode;
import com.google.common.io.BaseEncoding;
import io.nixer.bloom.NotHexStringException;
import io.nixer.bloom.check.HashingStrategy;

class NoHashing
implements HashingStrategy {
    NoHashing() {
    }

    @Override
    public byte[] convertToBytes(String value) {
        if (this.isHexString(value)) {
            return HashCode.fromString((String)value.toLowerCase()).asBytes();
        }
        throw new NotHexStringException((CharSequence)value);
    }

    private boolean isHexString(String value) {
        return !Strings.isNullOrEmpty((String)value) && BaseEncoding.base16().canDecode((CharSequence)value);
    }
}

