/*
 * Decompiled with CFR 0.152.
 */
package io.nixer.bloom.check;

import com.google.common.base.Preconditions;
import com.google.common.hash.Funnels;
import io.nixer.bloom.BloomFilter;
import io.nixer.bloom.FileBasedBloomFilter;
import io.nixer.bloom.check.HashingStrategy;
import io.nixer.bloom.check.NoHashing;
import io.nixer.bloom.check.Sha1Hashing;
import java.nio.file.Path;
import java.util.function.Predicate;

public class BloomFilterCheck
implements Predicate<String> {
    private final BloomFilter<byte[]> bloomFilter;
    private final HashingStrategy hashingStrategy;

    private BloomFilterCheck(BloomFilter<byte[]> bloomFilter, HashingStrategy hashingStrategy) {
        Preconditions.checkNotNull(bloomFilter, (Object)"bloomFilter");
        Preconditions.checkNotNull((Object)hashingStrategy, (Object)"hashingStrategy");
        this.bloomFilter = bloomFilter;
        this.hashingStrategy = hashingStrategy;
    }

    @Override
    public boolean test(String value) {
        byte[] valueBytes = this.hashingStrategy.convertToBytes(value);
        return this.bloomFilter.mightContain(valueBytes);
    }

    public static BloomFilterCheck hashingBeforeCheck(Path filename) {
        return new BloomFilterCheck(BloomFilterCheck.openBloomFilter(filename), new Sha1Hashing());
    }

    public static BloomFilterCheck notHashingBeforeCheck(Path filename) {
        return new BloomFilterCheck(BloomFilterCheck.openBloomFilter(filename), new NoHashing());
    }

    private static BloomFilter<byte[]> openBloomFilter(Path filename) {
        return FileBasedBloomFilter.open(filename, Funnels.byteArrayFunnel());
    }
}

