/*
 * Decompiled with CFR 0.152.
 */
package io.nixer.bloom;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.hash.Funnel;
import io.nixer.bloom.BitArray;
import io.nixer.bloom.BitArrayFactories;
import io.nixer.bloom.BloomFilter;
import io.nixer.bloom.BloomFilterParameters;
import io.nixer.fork.com.google.common.hash.GuavaBloomFilter;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import javax.annotation.Nonnull;

public class FileBasedBloomFilter {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Nonnull
    public static <T> BloomFilter<T> create(@Nonnull Path filename, @Nonnull Funnel<? super T> funnel, long expectedInsertions, double falsePositivesProbability) {
        Preconditions.checkNotNull((Object)filename, (Object)"filename");
        Preconditions.checkNotNull(funnel, (Object)"funnel");
        Preconditions.checkArgument((expectedInsertions > 0L ? 1 : 0) != 0, (String)"expectedInsertions=%s must be bigger than zero", (long)expectedInsertions);
        Preconditions.checkArgument((falsePositivesProbability > 0.0 ? 1 : 0) != 0, (String)"falsePositivesProbability=%s must be bigger than zero", (Object)falsePositivesProbability);
        Preconditions.checkArgument((falsePositivesProbability < 1.0 ? 1 : 0) != 0, (String)"falsePositivesProbability=%s must be less than 1.0", (Object)falsePositivesProbability);
        BitArray.Factory factory = BitArrayFactories.mappedFile(FileBasedBloomFilter.getDataFilePath(filename), ByteOrder.nativeOrder());
        GuavaBloomFilter<T> filter = GuavaBloomFilter.create(funnel, expectedInsertions, falsePositivesProbability, factory);
        try {
            MAPPER.writeValue(filename.toFile(), (Object)filter.getParameters());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to save metadata for " + filename, e);
        }
        return filter;
    }

    @Nonnull
    public static <T> BloomFilter<T> open(@Nonnull Path filename, @Nonnull Funnel<? super T> funnel) {
        BloomFilterParameters parameters;
        Preconditions.checkNotNull((Object)filename, (Object)"filename");
        Preconditions.checkNotNull(funnel, (Object)"funnel");
        try {
            parameters = (BloomFilterParameters)MAPPER.readValue(filename.toFile(), BloomFilterParameters.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read metadata from " + filename, e);
        }
        BitArray.Factory factory = BitArrayFactories.mappedFile(FileBasedBloomFilter.getDataFilePath(filename), parameters.getByteOrder());
        return GuavaBloomFilter.create(funnel, factory, parameters);
    }

    @Nonnull
    public static Path getDataFilePath(@Nonnull Path mainPath) {
        return mainPath.resolveSibling(mainPath.getFileName() + "-data");
    }
}

