/*
 * Decompiled with CFR 0.152.
 */
package io.nixer.bloom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.nixer.fork.com.google.common.hash.GuavaBloomFilter;
import io.nixer.fork.com.google.common.hash.GuavaBloomFilterStrategies;
import java.nio.ByteOrder;
import java.util.Map;
import javax.annotation.Nonnull;

public class BloomFilterParameters {
    private static final Map<String, ByteOrder> BYTE_ORDER_MAP = ImmutableMap.of((Object)ByteOrder.BIG_ENDIAN.toString(), (Object)ByteOrder.BIG_ENDIAN, (Object)ByteOrder.LITTLE_ENDIAN.toString(), (Object)ByteOrder.LITTLE_ENDIAN);
    private final long expectedInsertions;
    private final double falsePositivesProbability;
    private final int numHashFunctions;
    private final long bitSize;
    @Nonnull
    private final GuavaBloomFilterStrategies strategy;
    @Nonnull
    private final ByteOrder byteOrder;

    public BloomFilterParameters(long expectedInsertions, double falsePositivesProbability, int numHashFunctions, long bitSize, @Nonnull GuavaBloomFilterStrategies strategy, @Nonnull ByteOrder byteOrder) {
        Preconditions.checkNotNull((Object)strategy, (Object)"strategy");
        Preconditions.checkNotNull((Object)byteOrder, (Object)"byteOrder");
        this.expectedInsertions = expectedInsertions;
        this.falsePositivesProbability = falsePositivesProbability;
        this.numHashFunctions = numHashFunctions;
        this.bitSize = bitSize;
        this.strategy = strategy;
        this.byteOrder = byteOrder;
    }

    @JsonCreator
    public BloomFilterParameters(@JsonProperty(value="expectedInsertions") long expectedInsertions, @JsonProperty(value="falsePositivesProbability") double falsePositivesProbability, @JsonProperty(value="numHashFunctions") int numHashFunctions, @JsonProperty(value="bitSize") long bitSize, @JsonProperty(value="strategy") @Nonnull GuavaBloomFilterStrategies strategy, @JsonProperty(value="byteOrder") @Nonnull String byteOrder) {
        Preconditions.checkNotNull((Object)strategy, (Object)"strategy");
        Preconditions.checkNotNull((Object)byteOrder, (Object)"byteOrder");
        this.expectedInsertions = expectedInsertions;
        this.falsePositivesProbability = falsePositivesProbability;
        this.numHashFunctions = numHashFunctions;
        this.bitSize = bitSize;
        this.strategy = strategy;
        this.byteOrder = (ByteOrder)Preconditions.checkNotNull((Object)BYTE_ORDER_MAP.get(byteOrder), (Object)"Invalid value for byteOrder");
    }

    @JsonProperty
    public double getFalsePositivesProbability() {
        return this.falsePositivesProbability;
    }

    public long getExpectedInsertions() {
        return this.expectedInsertions;
    }

    @JsonProperty
    public int getNumHashFunctions() {
        return this.numHashFunctions;
    }

    @JsonProperty
    public long getBitSize() {
        return this.bitSize;
    }

    @JsonProperty
    @Nonnull
    public GuavaBloomFilter.Strategy getStrategy() {
        return this.strategy;
    }

    @JsonIgnore
    @Nonnull
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @JsonProperty(value="byteOrder")
    @Nonnull
    public String getByteOrderString() {
        return this.byteOrder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BloomFilterParameters that = (BloomFilterParameters)o;
        if (this.expectedInsertions != that.expectedInsertions) {
            return false;
        }
        if (Double.compare(that.falsePositivesProbability, this.falsePositivesProbability) != 0) {
            return false;
        }
        if (this.numHashFunctions != that.numHashFunctions) {
            return false;
        }
        if (this.bitSize != that.bitSize) {
            return false;
        }
        if (!this.strategy.equals(that.strategy)) {
            return false;
        }
        return this.byteOrder.equals(that.byteOrder);
    }

    public int hashCode() {
        int result = (int)(this.expectedInsertions ^ this.expectedInsertions >>> 32);
        long temp = Double.doubleToLongBits(this.falsePositivesProbability);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.numHashFunctions;
        result = 31 * result + (int)(this.bitSize ^ this.bitSize >>> 32);
        result = 31 * result + this.strategy.hashCode();
        result = 31 * result + this.byteOrder.hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("expectedInsertions", this.expectedInsertions).add("falsePositivesProbability", this.falsePositivesProbability).add("numHashFunctions", this.numHashFunctions).add("bitSize", this.bitSize).add("strategy", (Object)this.strategy).add("byteOrder", (Object)this.byteOrder).toString();
    }
}

