/*
 * Decompiled with CFR 0.152.
 */
package io.nixer.bloom;

import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import io.nixer.bloom.BitArray;
import java.io.IOException;
import java.math.RoundingMode;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.annotation.Nonnull;

public class BitArrayMappedFile
implements BitArray {
    private static int SEGMENT_SIZE_POW_2 = 30;
    private static int SEGMENT_SIZE_BYTES = 1 << SEGMENT_SIZE_POW_2;
    private static int SEGMENT_SIZE_MASK = (1 << SEGMENT_SIZE_POW_2) - 1;
    private final long bitSize;
    private final MappedByteBuffer[] mappedByteBuffers;
    private final MappedByteBuffer firstByteBuffer;

    public BitArrayMappedFile(@Nonnull FileChannel fileChannel, @Nonnull ByteOrder byteOrder) throws IOException {
        Preconditions.checkNotNull((Object)fileChannel, (Object)"fileChannel");
        Preconditions.checkNotNull((Object)byteOrder, (Object)"byteOrder");
        long totalSizeInBytes = fileChannel.size();
        this.bitSize = totalSizeInBytes * 8L - 64L;
        Preconditions.checkArgument((this.bitSize > 0L ? 1 : 0) != 0, (Object)"Bloom filter data file is too small");
        int segments = Ints.checkedCast((long)LongMath.divide((long)totalSizeInBytes, (long)SEGMENT_SIZE_BYTES, (RoundingMode)RoundingMode.CEILING));
        assert (segments > 0);
        this.mappedByteBuffers = BitArrayMappedFile.createMappedByteBuffers(fileChannel, segments, byteOrder, totalSizeInBytes);
        this.firstByteBuffer = this.mappedByteBuffers[0];
    }

    @Nonnull
    private static MappedByteBuffer[] createMappedByteBuffers(@Nonnull FileChannel fileChannel, int segments, @Nonnull ByteOrder byteOrder, long totalSizeInBytes) throws IOException {
        MappedByteBuffer[] mappedByteBuffers = new MappedByteBuffer[segments];
        long remainingSize = totalSizeInBytes;
        long offset = 0L;
        for (int i = 0; i < segments; ++i) {
            long size = remainingSize > (long)SEGMENT_SIZE_BYTES ? (long)SEGMENT_SIZE_BYTES : remainingSize;
            mappedByteBuffers[i] = fileChannel.map(FileChannel.MapMode.READ_WRITE, offset, size);
            mappedByteBuffers[i].order(byteOrder);
            offset += size;
            assert ((remainingSize -= size) >= 0L);
            assert (offset <= totalSizeInBytes);
        }
        assert (remainingSize == 0L);
        assert (offset == totalSizeInBytes);
        return mappedByteBuffers;
    }

    @Override
    public boolean set(long index) {
        return !this.getAndMaybeSet(index, true);
    }

    @Override
    public boolean get(long index) {
        return this.getAndMaybeSet(index, false);
    }

    private boolean getAndMaybeSet(long index, boolean alsoSet) {
        long bitMask;
        boolean wasSet;
        long correctedIndex = index + 64L;
        long longPosition = correctedIndex >>> 6;
        long segmentIndex = longPosition >>> SEGMENT_SIZE_POW_2 - 3;
        int bytPositionInSegment = Ints.checkedCast((long)(longPosition << 3 & (long)SEGMENT_SIZE_MASK));
        MappedByteBuffer segment = this.mappedByteBuffers[Ints.checkedCast((long)segmentIndex)];
        long value = segment.getLong(bytPositionInSegment);
        boolean bl = wasSet = (value & (bitMask = 1L << (int)correctedIndex)) != 0L;
        if (wasSet || !alsoSet) {
            return wasSet;
        }
        long changedValue = value | bitMask;
        segment.putLong(bytPositionInSegment, changedValue);
        long newCount = this.firstByteBuffer.getLong(0) + 1L;
        this.firstByteBuffer.putLong(0, newCount);
        return false;
    }

    @Override
    public long bitSize() {
        return this.bitSize;
    }

    @Override
    public long bitCount() {
        return this.firstByteBuffer.getLong(0);
    }
}

