/*
 * Decompiled with CFR 0.152.
 */
package io.nixer.bloom;

import com.google.common.base.Preconditions;
import io.nixer.bloom.BitArray;
import io.nixer.bloom.BitArrayMappedFile;
import io.nixer.fork.com.google.common.hash.GuavaBloomFilterStrategies;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.file.Path;
import javax.annotation.Nonnull;

public class BitArrayFactories {
    public static BitArray.Factory inMemory() {
        return GuavaBloomFilterStrategies.BitArrayInMemory::new;
    }

    public static BitArray.Factory mappedFile(@Nonnull Path path, @Nonnull ByteOrder byteOrder) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        Preconditions.checkNotNull((Object)byteOrder, (Object)"byteOrder");
        return bitSize -> BitArrayFactories.buildBitArrayMappedFile(path, bitSize, byteOrder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private static BitArray buildBitArrayMappedFile(@Nonnull Path path, long bitSize, @Nonnull ByteOrder byteOrder) {
        try (RandomAccessFile openedFile = new RandomAccessFile(path.toFile(), "rw");){
            BitArrayFactories.validateAndPotentiallyCorrectFileLength(bitSize, openedFile);
            BitArrayMappedFile bitArrayMappedFile = new BitArrayMappedFile(openedFile.getChannel(), byteOrder);
            return bitArrayMappedFile;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to open a bloom filter data because an I/O failure file=" + path, e);
        }
    }

    private static void validateAndPotentiallyCorrectFileLength(long bitSize, @Nonnull RandomAccessFile openedFile) throws IOException {
        long numberOfLongsForData;
        long targetSize;
        long currentSize = openedFile.length();
        if (currentSize != (targetSize = ((numberOfLongsForData = (bitSize + 63L) / 64L) + 1L) * 8L)) {
            Preconditions.checkState((currentSize == 0L ? 1 : 0) != 0, (String)"Mismatch between actual and expected file size actual=%s expected=%s", (long)currentSize, (long)targetSize);
            openedFile.setLength(targetSize);
        }
    }
}

