/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.springweb;

import io.nflow.engine.service.WorkflowInstanceInclude;
import io.nflow.engine.service.WorkflowInstanceService;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import io.nflow.engine.workflow.instance.WorkflowInstanceAction;
import io.nflow.engine.workflow.instance.WorkflowInstanceFactory;
import io.nflow.rest.v1.ResourceBase;
import io.nflow.rest.v1.converter.CreateWorkflowConverter;
import io.nflow.rest.v1.converter.ListWorkflowInstanceConverter;
import io.nflow.rest.v1.msg.CreateWorkflowInstanceRequest;
import io.nflow.rest.v1.msg.CreateWorkflowInstanceResponse;
import io.nflow.rest.v1.msg.ListWorkflowInstanceResponse;
import io.nflow.rest.v1.msg.SetSignalRequest;
import io.nflow.rest.v1.msg.UpdateWorkflowInstanceRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.validation.Valid;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/${nflow.rest.path.prefix}/v1/workflow-instance"}, produces={"application/json"})
@Api(value="nFlow workflow instance management")
@Component
public class WorkflowInstanceResource
extends ResourceBase {
    private final WorkflowInstanceService workflowInstances;
    private final CreateWorkflowConverter createWorkflowConverter;
    private final ListWorkflowInstanceConverter listWorkflowConverter;
    private final WorkflowInstanceFactory workflowInstanceFactory;

    @Inject
    public WorkflowInstanceResource(WorkflowInstanceService workflowInstances, CreateWorkflowConverter createWorkflowConverter, ListWorkflowInstanceConverter listWorkflowConverter, WorkflowInstanceFactory workflowInstanceFactory) {
        this.workflowInstances = workflowInstances;
        this.createWorkflowConverter = createWorkflowConverter;
        this.listWorkflowConverter = listWorkflowConverter;
        this.workflowInstanceFactory = workflowInstanceFactory;
    }

    @PutMapping(consumes={"application/json"})
    @ApiOperation(value="Submit new workflow instance")
    @ApiResponses(value={@ApiResponse(code=201, message="Workflow was created", response=CreateWorkflowInstanceResponse.class)})
    public ResponseEntity<CreateWorkflowInstanceResponse> createWorkflowInstance(@RequestBody @ApiParam(value="Submitted workflow instance information", required=true) CreateWorkflowInstanceRequest req) {
        WorkflowInstance instance = this.createWorkflowConverter.convert(req);
        int id = this.workflowInstances.insertWorkflowInstance(instance);
        instance = this.workflowInstances.getWorkflowInstance(id, EnumSet.of(WorkflowInstanceInclude.CURRENT_STATE_VARIABLES), null);
        return ResponseEntity.created((URI)URI.create(String.valueOf(id))).body((Object)this.createWorkflowConverter.convert(instance));
    }

    @PutMapping(path={"/id/{id}"}, consumes={"application/json"})
    @ApiOperation(value="Update workflow instance", notes="The service is typically used in manual state transition via nFlow Explorer or a business UI.")
    @ApiResponses(value={@ApiResponse(code=204, message="If update was successful"), @ApiResponse(code=409, message="If workflow was executing and no update was done")})
    public ResponseEntity<?> updateWorkflowInstance(@ApiParam(value="Internal id for workflow instance") @PathVariable(value="id") int id, @RequestBody @ApiParam(value="Submitted workflow instance information") UpdateWorkflowInstanceRequest req) {
        boolean updated = super.updateWorkflowInstance(id, req, this.workflowInstanceFactory, this.workflowInstances);
        return (updated ? ResponseEntity.noContent() : ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT)).build();
    }

    @GetMapping(path={"/id/{id}"})
    @ApiOperation(value="Fetch a workflow instance", notes="Fetch full state and action history of a single workflow instance.")
    public ResponseEntity<ListWorkflowInstanceResponse> fetchWorkflowInstance(@ApiParam(value="Internal id for workflow instance") @PathVariable(value="id") int id, @RequestParam(value="include", required=false) @ApiParam(value="Data to include in response. currentStateVariables = current stateVariables for worfklow, actions = state transitions, actionStateVariables = state variable changes for actions, childWorkflows = map of created child workflow instance IDs by action ID", allowableValues="currentStateVariables,actions,actionStateVariables,childWorkflows", allowMultiple=true) String include, @RequestParam(value="maxActions", required=false) @ApiParam(value="Maximum number of actions returned for each workflow instance") Long maxActions) {
        try {
            return ResponseEntity.ok().body((Object)super.fetchWorkflowInstance(id, include, maxActions, this.workflowInstances, this.listWorkflowConverter));
        }
        catch (EmptyResultDataAccessException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @GetMapping
    @ApiOperation(value="List workflow instances", response=ListWorkflowInstanceResponse.class, responseContainer="List")
    public Collection<ListWorkflowInstanceResponse> listWorkflowInstances(@RequestParam(value="id", defaultValue="") @ApiParam(value="Internal id of workflow instance") List<Integer> ids, @RequestParam(value="type", defaultValue="") @ApiParam(value="Workflow definition type of workflow instance") List<String> types, @RequestParam(value="parentWorkflowId", required=false) @ApiParam(value="Id of parent workflow instance") Integer parentWorkflowId, @RequestParam(value="parentActionId", required=false) @ApiParam(value="Id of parent workflow instance action") Integer parentActionId, @RequestParam(value="state", defaultValue="") @ApiParam(value="Current state of workflow instance") List<String> states, @RequestParam(value="status", defaultValue="") @ApiParam(value="Current status of workflow instance") List<WorkflowInstance.WorkflowInstanceStatus> statuses, @RequestParam(value="businessKey", required=false) @ApiParam(value="Business key for workflow instance") String businessKey, @RequestParam(value="externalId", required=false) @ApiParam(value="External id for workflow instance") String externalId, @RequestParam(value="include", required=false) @ApiParam(value="Data to include in response. currentStateVariables = current stateVariables for worfklow, actions = state transitions, actionStateVariables = state variable changes for actions, childWorkflows = map of created child workflow instance IDs by action ID", allowableValues="currentStateVariables,actions,actionStateVariables,childWorkflows", allowMultiple=true) String include, @RequestParam(value="maxResults", required=false) @ApiParam(value="Maximum number of workflow instances to be returned") Long maxResults, @RequestParam(value="maxActions", required=false) @ApiParam(value="Maximum number of actions returned for each workflow instance") Long maxActions) {
        return super.listWorkflowInstances(ids, types, parentWorkflowId, parentActionId, states, statuses, businessKey, externalId, include, maxResults, maxActions, this.workflowInstances, this.listWorkflowConverter);
    }

    @PutMapping(path={"/{id}/signal"}, consumes={"application/json"})
    @ApiOperation(value="Set workflow instance signal value", notes="The service may be used for example to interrupt executing workflow instance.")
    @ApiResponses(value={@ApiResponse(code=200, message="When operation was successful")})
    public ResponseEntity<?> setSignal(@ApiParam(value="Internal id for workflow instance") @PathVariable(value="id") int id, @RequestBody @Valid @ApiParam(value="New signal value") SetSignalRequest req) {
        boolean updated = this.workflowInstances.setSignal(Integer.valueOf(id), Optional.ofNullable(req.signal), req.reason, WorkflowInstanceAction.WorkflowActionType.externalChange);
        return updated ? ResponseEntity.ok((Object)"Signal was set successfully") : ResponseEntity.ok((Object)"Signal was not set");
    }
}

