/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.springweb;

import io.nflow.engine.service.WorkflowExecutorService;
import io.nflow.rest.v1.converter.ListWorkflowExecutorConverter;
import io.nflow.rest.v1.msg.ListWorkflowExecutorResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/${nflow.rest.path.prefix}/v1/workflow-executor"}, produces={"application/json"})
@Api(value="nFlow workflow executor management")
@Component
public class WorkflowExecutorResource {
    private final WorkflowExecutorService workflowExecutors;
    private final ListWorkflowExecutorConverter converter;

    @Autowired
    public WorkflowExecutorResource(WorkflowExecutorService workflowExecutors, ListWorkflowExecutorConverter converter) {
        this.workflowExecutors = workflowExecutors;
        this.converter = converter;
    }

    @GetMapping
    @ApiOperation(value="List workflow executors", response=ListWorkflowExecutorResponse.class, responseContainer="List")
    public Collection<ListWorkflowExecutorResponse> listWorkflowExecutors() {
        return this.workflowExecutors.getWorkflowExecutors().stream().map(executor -> this.converter.convert(executor)).collect(Collectors.toList());
    }
}

