/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.springweb;

import io.nflow.engine.service.StatisticsService;
import io.nflow.rest.v1.converter.StatisticsConverter;
import io.nflow.rest.v1.msg.StatisticsResponse;
import io.nflow.rest.v1.msg.WorkflowDefinitionStatisticsResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/${nflow.rest.path.prefix}/v1/statistics"}, produces={"application/json"})
@Api(value="nFlow statistics")
@Component
public class StatisticsResource {
    @Inject
    private StatisticsService statisticsService;
    @Inject
    private StatisticsConverter statisticsConverter;

    @GetMapping
    @ApiOperation(value="Get executor group statistics", notes="Returns counts of queued and executing workflow instances.")
    public StatisticsResponse queryStatistics() {
        return this.statisticsConverter.convert(this.statisticsService.getStatistics());
    }

    @GetMapping(path={"/workflow/{type}"})
    @ApiOperation(value="Get workflow definition statistics")
    public WorkflowDefinitionStatisticsResponse getStatistics(@PathVariable(value="type") @ApiParam(value="Workflow definition type", required=true) String type, @RequestParam(value="createdAfter", required=false) @ApiParam(value="Include only workflow instances created after given time") DateTime createdAfter, @RequestParam(value="createdBefore", required=false) @ApiParam(value="Include only workflow instances created before given time") DateTime createdBefore, @RequestParam(value="modifiedAfter", required=false) @ApiParam(value="Include only workflow instances modified after given time") DateTime modifiedAfter, @RequestParam(value="modifiedBefore", required=false) @ApiParam(value="Include only workflow instances modified before given time") DateTime modifiedBefore) {
        return this.statisticsConverter.convert(this.statisticsService.getWorkflowDefinitionStatistics(type, createdAfter, createdBefore, modifiedAfter, modifiedBefore));
    }
}

